/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AmbiguousBindTest
extends ValidationTest {
    private static final String FOO_0 = "public virtual class Foo0 {}";
    private static final String FOO_1 = "public virtual class Foo1 extends Foo0 {}";
    private static final String FOO_2 = "public virtual class Foo2 extends Foo1 {}";

    @DataProvider
    Object[][] ambiguousBindingData() {
        return new Object[][]{{ImmutableList.of("public class Foo { void foo(Integer i) {} void foo(Long l) {} { foo(null); } }"), I18nSupport.getLabel("ambiguous.method.signature", "void foo(null)")}, {ImmutableList.of("public class Foo { public void foo(Integer i1, Integer i2) {} public void foo(Integer i, Long l) {} }", "public class Bar { { new Foo().foo(1, null); } }"), I18nSupport.getLabel("ambiguous.method.signature", "void foo(Integer, null)")}, {ImmutableList.of("public class Foo { public Foo(Integer i) {} public Foo(String s) {} public Foo() { this(null); } }"), I18nSupport.getLabel("ambiguous.method.signature", "void <init>(null)")}, {ImmutableList.of("public virtual class Foo { public Foo(Integer i) {} public Foo(String s) {} public Foo() { } }", "public class Bar extends Foo { public Bar() { super(null); } }"), I18nSupport.getLabel("ambiguous.method.signature", "void <init>(null)")}};
    }

    @Test(dataProvider="ambiguousBindingData")
    public void testAmbiguousBinding(List<String> source, String error) {
        this.tester.assertFailure(source, error);
    }

    @DataProvider
    Object[][] unambiguousBindingData() {
        return new Object[][]{{ImmutableList.of(FOO_0, FOO_1, FOO_2, "public interface IFoo { void foo(Foo1 f); void foo(Foo2 f); }", "public class FooImpl implements IFoo { public void foo(Foo1 f); public void foo(Foo2 f); }")}, {ImmutableList.of(FOO_0, FOO_1, FOO_2, "public interface IFoo { void foo(Foo1 f); void foo(Foo2 f); }", "public class FooImpl implements IFoo { public void foo(Foo0 f); }")}, {ImmutableList.of(FOO_0, FOO_1, FOO_2, "public interface IFoo { void foo(Foo1 f); void foo(Foo2 f); }", "public class FooImpl implements IFoo { public void foo(Foo1 f); public void foo(Foo0 f); }")}};
    }

    @Test(dataProvider="unambiguousBindingData")
    public void testUnambiguousBinding(List<String> source) {
        this.tester.assertSuccess(source);
    }

    @Test
    public void testObjectDistance() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add("global virtual class Foo0 {}");
        for (int i = 0; i <= 10; ++i) {
            builder.add("global virtual class Foo" + (i + 1) + " extends Foo" + i + " {}");
        }
        builder.add("global class Bar { void m(Foo0 f) {} void m(Object o) {} { m(new Foo10()); } }");
        this.tester.assertFailure((List<String>)((Object)builder.build()), I18nSupport.getLabel("ambiguous.method.signature", "void m(Foo10)"));
    }

    @Test
    public void testMethodClash() {
        this.tester.assertFailure("public class Foo { static void foo(Long i) {} void foo(Integer i) {} }", I18nSupport.getLabel("cannot.override.static.method", "void Foo.foo(Long)", "void Foo.foo(Integer)"));
    }
}

