/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.JadtFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.tester.TestModifierGroups;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class AllowCertifiedApexVisibilityTest {
    private static final ModifierGroup ALLOW_CERTIFIED_APEX_MODIFIER_GROUP = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotation(AnnotationTypeInfos.ALLOW_CERTIFIED_APEX.getApexName())).build().resolve();
    @Mock
    private AccessEvaluator accessEvaluator;

    @BeforeTest
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testAllowCertifiedApexVisibleThroughClass() {
        Mockito.when((Object)this.accessEvaluator.isTrustedApplication()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)Visibility.isMethodAllowCertifiedApexVisible(this.accessEvaluator, TestModifierGroups.EMPTY, ALLOW_CERTIFIED_APEX_MODIFIER_GROUP), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAllowCertifiedApexVisibleThroughMethod() {
        Mockito.when((Object)this.accessEvaluator.isTrustedApplication()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)Visibility.isMethodAllowCertifiedApexVisible(this.accessEvaluator, ALLOW_CERTIFIED_APEX_MODIFIER_GROUP, TestModifierGroups.EMPTY), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAllowCertifiedApexNotVisible() {
        Mockito.when((Object)this.accessEvaluator.isTrustedApplication()).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)Visibility.isMethodAllowCertifiedApexVisible(this.accessEvaluator, ALLOW_CERTIFIED_APEX_MODIFIER_GROUP, TestModifierGroups.EMPTY), (Matcher)Matchers.is((Object)false));
    }
}

