/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableValidateStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestNode;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.ErrorMatchers;
import apex.jorje.services.I18nSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class VariableValidateVisitorTest {
    private static final TypeInfo PRIVATE_FOO = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("Foo")).setModifiers(ModifierGroups.PRIVATE)).buildResolved();
    private static final TypeInfo PUBLIC_FOO = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("Foo")).setModifiers(ModifierGroups.GLOBAL)).buildResolved();
    private static final TypeInfo PRIVATE_INNER_FOO = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("InnerFoo")).setModifiers(ModifierGroups.PRIVATE)).setEnclosingType(PUBLIC_FOO)).buildResolved();
    private static final TypeInfo TRIGGER_FOO = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(TestConstants.EMPTY_SOURCE, CompilationUnitBuilder.emptyTrigger((String)"Foo"))).buildResolved();
    private static final AstNode TRIGGER_NODE = TestNode.create(TRIGGER_FOO);
    private static final AstNode BAR_NODE = TestNode.create(TestConstants.BAR);
    private final StandardMethodInfoBuilder methodInfoBuilder = StandardMethodInfo.builder().setName("m").setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).setReturnType(TypeInfos.VOID);
    private SymbolResolver symbols;
    private VariableValidateLoadVisitor loadVisitor;
    private VariableValidateStoreVisitor storeVisitor;
    private Errors loadErrors;
    private Errors storeErrors;
    private ValidationScope storeScope;
    private VariableVisitor.Context context;
    @Mock
    private AstNode node;

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node.getLoc()).thenReturn((Object)Loc._SyntheticLoc());
        Mockito.when((Object)this.node.getDefiningType()).thenReturn((Object)TestConstants.BAR);
        this.symbols = TestSymbolResolvers.createEmptySymbols();
        this.loadErrors = new Errors();
        this.storeErrors = new Errors();
        ValidationScope loadScope = new ValidationScope(this.symbols, this.loadErrors);
        this.storeScope = new ValidationScope(this.symbols, this.storeErrors);
        this.loadVisitor = VariableValidateLoadVisitor.create(this.symbols, loadScope, this.node);
        this.storeVisitor = VariableValidateStoreVisitor.create(this.symbols, this.storeScope, this.node);
        this.context = new VariableVisitor.Context();
    }

    private void assertLoad(Variable info, String expectedError) {
        info.accept(this.loadVisitor, this.context);
        MatcherAssert.assertThat(this.loadErrors.get(), ErrorMatchers.containsErrors(expectedError));
    }

    private void assertStore(Variable info, String expectedError) {
        info.accept(this.storeVisitor, this.context);
        MatcherAssert.assertThat(this.storeErrors.get(), ErrorMatchers.containsErrors(expectedError));
    }

    @Test
    public void testLocalTypeNotVisible() {
        LocalInfo localInfo = LocalInfo.builder().setName("local").setType(PRIVATE_FOO).setDefiningType(TestConstants.BAR).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        this.assertLoad(localInfo, I18nSupport.getLabel("type.not.visible", "Foo"));
        this.assertStore(localInfo, I18nSupport.getLabel("type.not.visible", "Foo"));
    }

    @Test
    public void testLocalDefiningTypeNotVisible() {
        LocalInfo localInfo = LocalInfo.builder().setName("f").setType(PUBLIC_FOO).setDefiningType(PRIVATE_INNER_FOO).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        this.assertLoad(localInfo, I18nSupport.getLabel("type.not.visible", "InnerFoo"));
        this.assertStore(localInfo, I18nSupport.getLabel("type.not.visible", "InnerFoo"));
    }

    @Test
    public void testFieldNotVisible() {
        StandardFieldInfo fieldInfo = (StandardFieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(PUBLIC_FOO)).setModifiers(ModifierGroups.PRIVATE)).build();
        this.assertLoad(fieldInfo, I18nSupport.getLabel("variable.not.visible", "Foo.i"));
        this.assertStore(fieldInfo, I18nSupport.getLabel("variable.not.visible", "Foo.i"));
    }

    @Test
    public void testNonStaticFieldWithStaticContext() {
        this.symbols.staticContext().set(false);
        StandardFieldInfo fieldInfo = (StandardFieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setDefiningType(TestConstants.BAR)).build();
        this.context.previous = IdentifierContext.STATIC;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("invalid.non.static.variable.context", "i", TestConstants.BAR));
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.non.static.variable.context", "i", TestConstants.BAR));
    }

    @Test
    public void testStaticFieldWithNonStaticContext() {
        this.symbols.staticContext().set(true);
        StandardFieldInfo fieldInfo = (StandardFieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setDefiningType(TestConstants.BAR)).build();
        this.context.previous = IdentifierContext.NONE;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("invalid.non.static.variable.context", "i", TestConstants.BAR));
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.non.static.variable.context", "i", TestConstants.BAR));
    }

    @Test
    public void testStaticFieldNonStaticContext() {
        this.symbols.staticContext().set(false);
        StandardFieldInfo fieldInfo = (StandardFieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setDefiningType(TestConstants.BAR)).build();
        this.context.previous = IdentifierContext.OBJECT;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("invalid.static.variable.context", "i", TestConstants.BAR));
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.static.variable.context", "i", TestConstants.BAR));
    }

    @Test
    public void testInvalidDynamicField() {
        this.symbols.staticContext().set(false);
        DynamicFieldInfo fieldInfo = (DynamicFieldInfo)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(PUBLIC_FOO)).setModifiers(ModifierGroups.PRIVATE)).setLoadEmitter(DynamicFieldInfo.VariableEmitter.NOOP).setStoreEmitter(DynamicFieldInfo.VariableEmitter.NOOP).build();
        this.context.previous = IdentifierContext.STATIC;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("variable.not.visible", "Foo.i"));
        this.assertStore(fieldInfo, I18nSupport.getLabel("variable.not.visible", "Foo.i"));
    }

    @Test
    public void testIllegalDynamicField() {
        this.symbols.staticContext().set(false);
        DynamicFieldInfo fieldInfo = (DynamicFieldInfo)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(PUBLIC_FOO)).setModifiers(ModifierGroups.PRIVATE)).build();
        this.context.previous = IdentifierContext.STATIC;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("invalid.field.type.load", fieldInfo.getName(), fieldInfo.getDefiningType()));
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.field.type.store", fieldInfo.getName(), fieldInfo.getDefiningType()));
    }

    @Test
    public void testIllegalContextDynamicField() {
        this.symbols.staticContext().set(false);
        DynamicFieldInfo fieldInfo = (DynamicFieldInfo)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(TestConstants.BAR)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setLoadEmitter(DynamicFieldInfo.VariableEmitter.NOOP).setStoreEmitter(DynamicFieldInfo.VariableEmitter.NOOP).build();
        this.context.previous = IdentifierContext.OBJECT;
        this.assertLoad(fieldInfo, I18nSupport.getLabel("invalid.static.variable.context", "i", TestConstants.BAR));
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.static.variable.context", "i", TestConstants.BAR));
    }

    @Test
    public void testValidDynamicField() {
        this.symbols.staticContext().set(false);
        DynamicFieldInfo fieldInfo = (DynamicFieldInfo)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(TestConstants.BAR)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setLoadEmitter(DynamicFieldInfo.VariableEmitter.NOOP).setStoreEmitter(DynamicFieldInfo.VariableEmitter.NOOP).build();
        this.context.previous = IdentifierContext.STATIC;
        fieldInfo.accept(this.loadVisitor, this.context);
        MatcherAssert.assertThat(this.loadErrors.get(), (Matcher)Matchers.empty());
        fieldInfo.accept(this.storeVisitor, this.context);
        MatcherAssert.assertThat(this.storeErrors.get(), (Matcher)Matchers.empty());
    }

    @Test
    public void testFinalFieldAssignment() {
        StandardFieldInfo fieldInfo = (StandardFieldInfo)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setType(TypeInfos.INTEGER)).setDefiningType(TestConstants.BAR)).setModifiers(ModifierGroups.GLOBAL_FINAL)).build();
        Method method = MethodFactory.create(BAR_NODE, this.methodInfoBuilder.setDefiningType(TestConstants.BAR), Statement.NOOP);
        method.resolve(this.symbols);
        this.storeScope.push(method);
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.final.field.assignment", "i"));
    }

    @Test
    public void testFinalTriggerPropertyAssignment() {
        TriggerPropertyInfo propertyInfo = (TriggerPropertyInfo)((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)((TriggerPropertyInfo.Builder)TriggerPropertyInfo.builder().setName("i")).setUnderlyingField(new Field(TRIGGER_NODE, (AbstractFieldInfo.Builder<? extends AbstractFieldInfo.Builder, ? extends FieldInfo>)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)((StandardFieldInfo.Builder)StandardFieldInfo.builder().setName("i")).setModifiers(ModifierGroups.GLOBAL_FINAL)).setType(TypeInfos.INTEGER)).setDefiningType(TRIGGER_FOO))).setModifiers(ModifierGroups.GLOBAL_FINAL)).setType(TypeInfos.INTEGER)).setDefiningType(TRIGGER_FOO)).build(this.symbols);
        Method method = MethodFactory.create(TRIGGER_NODE, this.methodInfoBuilder.setDefiningType(TRIGGER_FOO), Statement.NOOP);
        method.resolve(this.symbols);
        this.storeScope.push(method);
        this.assertStore(propertyInfo, I18nSupport.getLabel("invalid.final.field.assignment", "i"));
    }

    @Test
    public void testStaticSObjectFieldAssignment() {
        SObjectFieldInfo fieldInfo = (SObjectFieldInfo)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)SObjectFieldInfo.builder().setName("name")).setType(TypeInfos.STRING)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setDefiningType(TestConstants.BAR)).build();
        this.context.previous = IdentifierContext.STATIC;
        this.assertStore(fieldInfo, I18nSupport.getLabel("invalid.field.type.store", "name", TestConstants.BAR));
    }
}

