/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Loc;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.VoidResult;
import apex.jorje.semantic.common.util.StringUtil;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.member.variable.LocalVariableTable;
import apex.jorje.services.I18nSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Queues;
import java.util.Deque;

public class StandardLocalVariableTable
implements LocalVariableTable {
    private final Deque<LocalVariableScope> scopes = Queues.newArrayDeque();
    private boolean allowLazyDeclaration = false;

    private LocalInfo get(String name) {
        if (name == null) {
            return null;
        }
        for (LocalVariableScope scope : this.scopes) {
            LocalInfo localVariable = scope.get(name);
            if (localVariable == null) continue;
            return localVariable;
        }
        return null;
    }

    @Override
    public LocalInfo lookup(String name, Loc loc) {
        if (name == null) {
            return null;
        }
        for (LocalVariableScope scope : this.scopes) {
            LocalInfo localVariable = scope.lookup(name, loc, this.allowLazyDeclaration);
            if (localVariable == null) continue;
            return localVariable;
        }
        return null;
    }

    @Override
    public void push(LocalVariableScope locals) {
        this.scopes.push(locals);
    }

    @Override
    public void pop() {
        assert (!this.scopes.isEmpty()) : "Can't pop local variables because you haven't pushed a scope.";
        this.scopes.pop();
    }

    @Override
    public int numberOfScopes() {
        return this.scopes.size();
    }

    @Override
    public Result<Void> add(LocalInfo variable) {
        LocalInfo oldLocalInfo = this.get(variable.getName());
        assert (!this.scopes.isEmpty()) : "Can't add local variable because you haven't pushed a scope.";
        assert (!StringUtil.isThis(variable.getName()) || this.scopes.size() == 1) : "Can't add 'this' because you are not at the lowest scope: " + this.scopes.size();
        assert (!StringUtil.isThis(variable.getName()) || this.scopes.peek().size() == 0) : "'this' must always be in the 0 position: " + this.scopes.peek().size();
        if (oldLocalInfo != null) {
            return VoidResult.error(I18nSupport.getLabel("duplicate.variable", variable.getName()));
        }
        this.scopes.peek().add(variable);
        return VoidResult.of();
    }

    @Override
    public LocalVariableScope peek() {
        return this.scopes.peek();
    }

    @Override
    public void setAllowLazyDeclaration(boolean allowLazyDeclaration) {
        this.allowLazyDeclaration = allowLazyDeclaration;
    }

    @Override
    public void clearAllowLazyDeclaration() {
        this.allowLazyDeclaration = false;
    }

    @Override
    public boolean allowLazyDeclaration() {
        return this.allowLazyDeclaration;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("scopes", this.scopes).add("allowLazyDeclaration", this.allowLazyDeclaration).toString();
    }
}

