/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.VoidResult;
import apex.jorje.semantic.common.iterable.LinkedCaseInsensitiveMap;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;
import java.util.Map;

public class MultipleFieldTable
implements FieldTable {
    private final Map<String, FieldInfo> fields = new LinkedCaseInsensitiveMap<FieldInfo>();
    private final Map<String, FieldInfo> staticFields = new LinkedCaseInsensitiveMap<FieldInfo>();
    private boolean resolved = false;

    @Override
    public Result<Void> add(FieldInfo field) {
        Map<String, FieldInfo> table;
        assert (!this.resolved) : "can't add fields after field table is resolved";
        boolean isStatic = field.getModifiers().has(ModifierTypeInfos.STATIC);
        Map<String, FieldInfo> map = table = isStatic ? this.staticFields : this.fields;
        if (!isStatic && this.staticFields.containsKey(field.getName()) || table.containsKey(field.getName())) {
            return VoidResult.error(I18nSupport.getLabel("duplicate.field", field.getName()));
        }
        table.put(field.getName(), field);
        return VoidResult.of();
    }

    @Override
    public FieldInfo get(SymbolResolver symbols, TypeInfo referencingType, String name, boolean checkStaticsFirst) {
        assert (this.resolved) : "can't get fields until field table is resolved";
        if (checkStaticsFirst) {
            FieldInfo field = this.staticFields.get(name);
            return field;
        }
        FieldInfo field = this.fields.get(name);
        return field != null ? field : this.staticFields.get(name);
    }

    @Override
    public FieldTable resolve() {
        this.resolved = true;
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public Iterable<FieldInfo> all() {
        return Iterables.concat(this.fields.values(), this.staticFields.values());
    }
}

