/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.JadtTester;
import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalVariableScopeTest {
    private static final String NULL_STRING = null;
    private static final boolean ALLOW_LAZY_DECLARATION = true;
    private static final boolean DISALLOW_LAZY_DECLARATION = false;
    private LocalInfo localBar;
    private LocalInfo localFoo;
    private LocalInfo localNull;
    private LocalVariableScope scope;

    @BeforeMethod
    public void setUp() {
        this.scope = new LocalVariableScope();
        this.localFoo = LocalInfo.builder().setName(Identifier._Identifier(JadtTester.pos((int)6, (int)0), "foo")).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        this.localBar = LocalInfo.builder().setName(Identifier._Identifier(JadtTester.pos((int)5, (int)0), "bar")).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        this.localNull = LocalInfo.builder().setName(NULL_STRING).setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    }

    @Test
    public void testGet() {
        this.scope.add(this.localNull);
        this.scope.add(this.localFoo);
        MatcherAssert.assertThat((Object)this.scope.get("fOO"), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.scope.get("bar"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.scope.get(null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testNullNamedLocalsGetMangled() {
        this.scope.add(this.localNull);
        MatcherAssert.assertThat(this.scope.all(), (Matcher)Matchers.contains((Object[])new LocalInfo[]{this.localNull}));
        MatcherAssert.assertThat((Object)this.scope.get("++null++0"), (Matcher)Matchers.is((Object)this.localNull));
    }

    @Test
    public void testGetWithNoContext() {
        this.scope.add(this.localFoo);
        MatcherAssert.assertThat((Object)this.scope.lookup("FOO", Loc._SyntheticLoc(), false), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.scope.lookup("fOO", Loc._SyntheticLoc(), false), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.scope.lookup("bar", Loc._SyntheticLoc(), false), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.scope.lookup("fOO", JadtTester.pos((int)4, (int)0), false), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.localBar.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testLazyDeclarationUsedBeforeDefined() {
        this.scope.add(this.localFoo);
        MatcherAssert.assertThat((Object)this.scope.lookup("FOO", Loc._SyntheticLoc(), true), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.scope.lookup("fOO", JadtTester.pos((int)4, (int)0), true), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)true));
        this.scope.setDeclaration(this.localFoo);
        MatcherAssert.assertThat((Object)this.scope.lookup("foo", Loc._SyntheticLoc(), true), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testLazyDeclarationUsedInDefined() {
        this.scope.add(this.localFoo);
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
        this.scope.setDeclaration(this.localFoo);
        MatcherAssert.assertThat((Object)this.scope.lookup("foo", Loc._SyntheticLoc(), true), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetWithContext() {
        this.scope.add(this.localFoo);
        this.scope.add(this.localBar);
        this.scope.setDeclaration(this.localBar);
        MatcherAssert.assertThat((Object)this.scope.lookup("foo", Loc._SyntheticLoc(), false), (Matcher)Matchers.is((Object)this.localFoo));
        MatcherAssert.assertThat((Object)this.scope.lookup("bar", Loc._SyntheticLoc(), false), (Matcher)Matchers.nullValue());
        this.scope.clearDeclaration();
        MatcherAssert.assertThat((Object)this.scope.lookup("bar", Loc._SyntheticLoc(), false), (Matcher)Matchers.is((Object)this.localBar));
        MatcherAssert.assertThat((Object)this.localFoo.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.localBar.isUsedBeforeDefined(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAll() {
        this.scope.add(this.localFoo);
        this.scope.add(this.localBar);
        MatcherAssert.assertThat(this.scope.all(), (Matcher)Matchers.contains((Object[])new LocalInfo[]{this.localFoo, this.localBar}));
        MatcherAssert.assertThat((Object)this.scope.size(), (Matcher)Matchers.is((Object)2));
    }
}

