/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Loc;
import apex.jorje.semantic.common.iterable.LinkedCaseInsensitiveMap;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.services.Location;
import java.util.Collection;
import java.util.Map;

public class LocalVariableScope {
    private final Map<String, LocalInfo> locals = new LinkedCaseInsensitiveMap<LocalInfo>();
    private LocalInfo declaration = null;

    public Collection<LocalInfo> all() {
        return this.locals.values();
    }

    void add(LocalInfo local) {
        if (local.getName() == null) {
            this.locals.put("++null++" + this.locals.size(), local);
            return;
        }
        this.locals.put(local.getName(), local);
    }

    LocalInfo get(String name) {
        return name == null ? null : this.locals.get(name);
    }

    LocalInfo lookup(String name, Loc loc, boolean allowLazyDeclaration) {
        LocalInfo local = this.locals.get(name);
        if (local == null) {
            return null;
        }
        if (this.isCalledBeforeDeclared(local, loc)) {
            if (allowLazyDeclaration) {
                local.setUsedBeforeDefined();
                return local;
            }
            return null;
        }
        return local;
    }

    private boolean isCalledBeforeDeclared(LocalInfo local, Loc loc) {
        return !Location.lessThanOrEqual(local.getLoc(), loc) || this.isDeclaration(local);
    }

    private boolean isDeclaration(LocalInfo local) {
        return this.declaration != null && this.declaration.getName().equalsIgnoreCase(local.getName());
    }

    int size() {
        return this.locals.size();
    }

    public void setDeclaration(LocalInfo declaration) {
        this.declaration = declaration;
    }

    public void clearDeclaration() {
        this.declaration = null;
    }
}

