/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldSupplier;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Map;

public class DynamicFieldTable
implements FieldTable {
    private final FieldSupplier supplier;
    private final Map<String, FieldInfo> fields;

    public DynamicFieldTable(FieldSupplier supplier) {
        this.supplier = supplier;
        this.fields = new CaseInsensitiveMap<FieldInfo>();
    }

    @Override
    public Result<Void> add(FieldInfo field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldTable resolve() {
        return this;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public Iterable<FieldInfo> all() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldInfo get(SymbolResolver symbols, TypeInfo referencingType, String name, boolean checkStaticsFirst) {
        FieldInfo field;
        if (this.fields.containsKey(name)) {
            field = this.fields.get(name);
        } else {
            field = this.supplier.get(symbols, referencingType, name);
            if (field != null) {
                this.fields.put(name, field);
            }
        }
        return field;
    }
}

