/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.VoidResult;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Equivalence;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class StandardMethodTable
implements MethodTable {
    private static final Equivalence<Signature> SIGNATURE_WRAPPER = new Equivalence<Signature>(){

        @Override
        protected boolean doEquivalent(Signature signature, Signature other) {
            return signature.equalsSignature(other);
        }

        @Override
        protected int doHash(Signature signature) {
            return signature.hashCodeSignature();
        }
    };
    private final Map<Equivalence.Wrapper<Signature>, MethodInfo> methods = Maps.newLinkedHashMap();
    private boolean resolved = false;

    @Override
    public Result<MethodInfo> getApproximate(Version applicableVersion, Signature signature, MethodLookupMode mode) {
        assert (this.resolved) : "can't get methods until method table is resolved";
        switch (mode) {
            case CONSTRUCTORS: {
                assert (signature.isConstructor());
                return this.getApproximate(applicableVersion, this.constructors(), signature);
            }
            case STATICS: {
                return this.getApproximate(applicableVersion, this.statics(), signature);
            }
            case INSTANCE: {
                return this.getApproximate(applicableVersion, this.instance(), signature);
            }
        }
        throw new UnexpectedCodePathException("unexpected mode: " + (Object)((Object)mode));
    }

    @Override
    public MethodInfo get(Signature signature) {
        return this.methods.get(SIGNATURE_WRAPPER.wrap(signature));
    }

    @Override
    public MethodInfo remove(Signature signature) {
        assert (!this.resolved) : "can't remove methods after method table is resolved";
        return this.methods.remove(SIGNATURE_WRAPPER.wrap(signature));
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        assert (!this.resolved) : "can't add methods after method table is resolved";
        if (this.methods.containsKey(SIGNATURE_WRAPPER.wrap(method.getSignature()))) {
            return VoidResult.error(I18nSupport.getLabel("method.already.exists", method.getSignature().getName(), method.getSignature().getValue(), method.getDefiningType()));
        }
        this.methods.put(SIGNATURE_WRAPPER.wrap(method.getSignature()), method);
        return VoidResult.of();
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        assert (!this.resolved) : "can't add methods after method table is resolved";
        MethodInfo parent = this.methods.get(SIGNATURE_WRAPPER.wrap(method.getSignature()));
        VoidResult result = VoidResult.of();
        if (parent != null && !TypeInfoEquivalence.isEquivalent(parent.getReturnType(), method.getReturnType())) {
            result = VoidResult.error(I18nSupport.getLabel("method.types.clash", method.getReturnType(), parent.getReturnType(), method.getDefiningType()));
        }
        this.methods.put(SIGNATURE_WRAPPER.wrap(method.getSignature()), method);
        return result;
    }

    @Override
    public MethodTable resolve() {
        this.resolved = true;
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public Collection<MethodInfo> all() {
        return this.methods.values();
    }

    @Override
    public Collection<MethodInfo> constructors() {
        return Collections2.filter(this.methods.values(), CONSTRUCTORS_ONLY);
    }

    @Override
    public Collection<MethodInfo> statics() {
        return Collections2.filter(this.methods.values(), STATICS_ONLY);
    }

    @Override
    public Collection<MethodInfo> instance() {
        return Collections2.filter(this.methods.values(), Predicates.not(Predicates.or(CONSTRUCTORS_ONLY, STATICS_ONLY)));
    }

    private Result<MethodInfo> getApproximate(Version applicableVersion, Collection<MethodInfo> methods, Signature signature) {
        Result<MethodInfo> currentBest = Result.none();
        int[] currentBestDistance = null;
        for (MethodInfo method : methods) {
            int[] candidateDistance;
            if (signature.getParameterTypes().size() != method.getParameterTypes().size() || !signature.getName().equalsIgnoreCase(method.getName()) || (candidateDistance = Distance.get().getDistance(applicableVersion, signature.getParameterTypes(), method.getParameterTypes())) == null) continue;
            int distanceDiff = Distance.get().isCloser(candidateDistance, currentBestDistance);
            if (distanceDiff < 0) {
                currentBest = Result.of(method);
                currentBestDistance = candidateDistance;
                continue;
            }
            if (distanceDiff != 0) continue;
            return Result.error(I18nSupport.getLabel("ambiguous.method.signature", signature));
        }
        return currentBest;
    }
}

