/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Loc;
import apex.jorje.data.ast.FormalParameter;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.ParameterUtil;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class StandardMethodInfoBuilder {
    private Generated generated;
    private TypeInfo definingType;
    private Identifier inputName;
    private Identifier name;
    private ModifierGroup modifiers;
    private List<Parameter> parameters = Collections.emptyList();
    private TypeReference returnType = null;
    private InvocationType invocationType = null;
    private Signature emitSignature;
    private JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation = null;
    private boolean isPropertyAccessor = false;
    private boolean isConstructor;
    private boolean isTriggerInvoke;
    private ProfilingType profilingType = ProfilingType.NONE;
    private boolean isDuckTyped;
    private List<BuiltInMethodValidator> validators = Collections.emptyList();

    StandardMethodInfoBuilder() {
    }

    public MethodInfo build() {
        assert (this.definingType != null) : "no defining type";
        assert (this.inputName != null) : "no inputName";
        assert (this.modifiers != null) : "no modifiers";
        assert (this.generated != null) : "no generated";
        Identifier identifier = this.name = this.isConstructor ? Identifier._Identifier(this.inputName.loc, "<init>") : this.inputName;
        this.invocationType = this.modifiers.has(ModifierTypeInfos.STATIC) ? InvocationType.STATIC : (this.isConstructor || this.isPropertyAccessor ? InvocationType.SPECIAL : InvocationType.VIRTUAL);
        return new StandardMethodInfo(this);
    }

    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    public StandardMethodInfoBuilder setModifiers(ModifierGroup modifiers) {
        assert (this.modifiers == null);
        assert (modifiers != null);
        this.modifiers = modifiers;
        return this;
    }

    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.javaSfdcOnlyAnnotation;
    }

    public StandardMethodInfoBuilder setJavaSfdcOnlyAnnotation(JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation) {
        this.javaSfdcOnlyAnnotation = javaSfdcOnlyAnnotation;
        return this;
    }

    public Loc getLoc() {
        return this.inputName.loc;
    }

    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    public StandardMethodInfoBuilder setEmitSignature(Signature signature) {
        this.emitSignature = signature;
        return this;
    }

    public Identifier getName() {
        return this.name;
    }

    public StandardMethodInfoBuilder setName(Identifier name) {
        this.inputName = name;
        return this;
    }

    public StandardMethodInfoBuilder setName(String name) {
        return this.setName(JadtFactory.identifier(name));
    }

    public Identifier getInputName() {
        return this.inputName;
    }

    public StandardMethodInfoBuilder setEmitSignature(String name, TypeInfo returnType, TypeInfo ... parameterTypes) {
        assert (parameterTypes.length == this.parameters.size());
        this.emitSignature = SignatureFactory.create(name, returnType, parameterTypes);
        return this;
    }

    public StandardMethodInfoBuilder setHiddenParameterTypes(TypeInfo ... parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toHidden(this.definingType, Arrays.asList(parameterTypes)));
    }

    public StandardMethodInfoBuilder setNamedParameterTypes(List<TypeInfo> parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toNamed(this.definingType, parameterTypes));
    }

    public StandardMethodInfoBuilder setNamedParameterTypes(TypeInfo ... parameterTypes) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toNamed(this.definingType, Arrays.asList(parameterTypes)));
    }

    public StandardMethodInfoBuilder setConstructor() {
        this.returnType = TypeReferences.createResolved(TypeInfos.VOID);
        this.inputName = JadtFactory.identifier("<init>");
        this.isConstructor = true;
        return this;
    }

    public StandardMethodInfoBuilder setPropertyAccessor() {
        this.isPropertyAccessor = true;
        return this;
    }

    public StandardMethodInfoBuilder setTriggerInvoke() {
        this.isTriggerInvoke = true;
        return this;
    }

    public Generated getGenerated() {
        return this.generated;
    }

    public StandardMethodInfoBuilder setGenerated(Generated generated) {
        assert (this.generated == null);
        this.generated = generated;
        return this;
    }

    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    public StandardMethodInfoBuilder setDefiningType(TypeInfo definingType) {
        this.definingType = definingType;
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public StandardMethodInfoBuilder setParameters(Parameter ... parameters) {
        return this.setParameters(ImmutableList.copyOf(parameters));
    }

    public StandardMethodInfoBuilder setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public StandardMethodInfoBuilder copyParameters(List<Parameter> parameters) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.copy(this.definingType, parameters));
    }

    public StandardMethodInfoBuilder setFormalParameters(List<FormalParameter> parameters) {
        assert (this.definingType != null) : "need to set defining type";
        return this.setParameters(ParameterUtil.toParameter(this.definingType, parameters));
    }

    public TypeReference getReturnType() {
        return this.returnType;
    }

    public StandardMethodInfoBuilder setReturnType(TypeInfo returnType) {
        this.returnType = TypeReferences.createResolved(returnType);
        return this;
    }

    public StandardMethodInfoBuilder setReturnType(Optional<TypeRef> type) {
        this.returnType = type.map(TypeReferences::createResolvable).orElse(TypeReferences.createResolved(TypeInfos.VOID));
        this.isConstructor = !type.isPresent();
        return this;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    @SfdcCalled
    public StandardMethodInfoBuilder setConstructor(boolean isConstructor) {
        if (isConstructor) {
            this.setConstructor();
        }
        return this;
    }

    public boolean isPropertyAccessor() {
        return this.isPropertyAccessor;
    }

    public boolean isTriggerInvoke() {
        return this.isTriggerInvoke;
    }

    public ProfilingType getProfilingType() {
        return this.profilingType;
    }

    public StandardMethodInfoBuilder setProfilingType(ProfilingType profilingType) {
        this.profilingType = profilingType;
        return this;
    }

    public StandardMethodInfoBuilder setDuckTyped() {
        this.isDuckTyped = true;
        return this;
    }

    public boolean isDuckTyped() {
        return this.isDuckTyped;
    }

    public StandardMethodInfoBuilder setValidators(BuiltInMethodValidator ... validators) {
        return this.setValidators(Arrays.asList(validators));
    }

    public List<BuiltInMethodValidator> getValidators() {
        return this.validators;
    }

    public StandardMethodInfoBuilder setValidators(List<BuiltInMethodValidator> validators) {
        this.validators = Collections.unmodifiableList(validators);
        return this;
    }
}

