/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.MemberVisitor;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.base.MoreObjects;
import java.util.List;

public class StandardMethodInfo
implements MethodInfo {
    private final TypeInfo definingType;
    private final Identifier name;
    private final Identifier inputName;
    private final List<Parameter> parameters;
    private final InvocationType invocationType;
    private final TypeInfo returnType;
    private final Signature signature;
    private final Signature emitSignature;
    private final boolean isConstructor;
    private final ModifierGroup modifiers;
    private final JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation;
    private final Generated generated;
    private final boolean isStaticInitialization;
    private final String mangledName;
    private final ProfilingType profilingType;
    private final boolean isDuckTyped;
    private final List<BuiltInMethodValidator> validators;
    private final boolean isPropertyAccessor;
    private final boolean isTriggerInvoke;
    private String canonicalName;
    private String mangledCanonicalName;
    private MethodInfo methodInterface;

    StandardMethodInfo(StandardMethodInfoBuilder builder) {
        this.definingType = builder.getDefiningType();
        this.name = builder.getName();
        this.inputName = builder.getInputName();
        this.modifiers = builder.getModifiers();
        this.javaSfdcOnlyAnnotation = builder.getJavaSfdcOnlyAnnotation();
        this.parameters = builder.getParameters();
        this.returnType = builder.getReturnType().get();
        this.invocationType = builder.getInvocationType();
        this.signature = new Signature(this.name.value, this.definingType, this.returnType, Parameter.toType(this.parameters));
        this.emitSignature = MoreObjects.firstNonNull(builder.getEmitSignature(), this.signature);
        this.isConstructor = builder.isConstructor();
        this.isStaticInitialization = this.name.value.equals("<clinit>");
        this.canonicalName = this.name.value;
        this.generated = builder.getGenerated();
        this.mangledCanonicalName = this.mangledName = MethodNameMangler.getMangledName(this, this.name.value);
        this.profilingType = builder.getProfilingType();
        this.isDuckTyped = builder.isDuckTyped();
        this.validators = builder.getValidators();
        this.isPropertyAccessor = builder.isPropertyAccessor();
        this.isTriggerInvoke = builder.isTriggerInvoke();
    }

    public static StandardMethodInfoBuilder builder() {
        return new StandardMethodInfoBuilder();
    }

    @Override
    public Identifier getIdentifier() {
        return this.inputName;
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    @Override
    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.javaSfdcOnlyAnnotation;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.isPropertyAccessor;
    }

    @Override
    public boolean isTriggerInvoke() {
        return this.isTriggerInvoke;
    }

    @Override
    public boolean isStaticInitialization() {
        return this.isStaticInitialization;
    }

    @Override
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        assert (canonicalName.equalsIgnoreCase(this.name.value));
        this.canonicalName = canonicalName;
        this.mangledCanonicalName = MethodNameMangler.getMangledName(this, canonicalName);
    }

    @Override
    public MethodInfo getMethodInterface() {
        return this.methodInterface;
    }

    @Override
    public void setMethodInterface(MethodInfo methodInterface) {
        assert (methodInterface != this);
        this.methodInterface = methodInterface;
    }

    @Override
    public Generated getGenerated() {
        return this.generated;
    }

    @Override
    public boolean hasReturnValue() {
        return !TypeInfoEquivalence.isEquivalent(this.returnType, TypeInfos.VOID);
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return AsmMethod.builder().invoke(this.invocationType).setDefiningTypeAsBytecodeMethodName(this.getDefiningType()).setFunction(this.getMangledCanonicalName()).setSignature(this.emitSignature);
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.getAsmMethodBuilder().build();
    }

    @Override
    public String getMangledName() {
        return this.mangledName;
    }

    @Override
    public String getMangledCanonicalName() {
        return this.mangledCanonicalName;
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.profilingType;
    }

    @Override
    public boolean isDuckTyped() {
        return this.isDuckTyped;
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.validators;
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return false;
    }

    @Override
    public String getName() {
        return this.name.value;
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.METHOD;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public <T> T accept(MemberVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Loc getLoc() {
        return this.name.loc;
    }

    public String toString() {
        return this.getSignature().toString();
    }
}

