/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.common.util.StringUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.MyInterner;
import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class Signature {
    private final String name;
    private final boolean isConstructor;
    private final TypeInfo returnType;
    private final List<TypeInfo> parameterTypes;
    private final List<Equivalence.Wrapper<? extends TypeInfo>> parameterEquivalence;
    private final String bytecodeSignature;
    private final String apexSignature;

    Signature(String name, TypeInfo definingType, TypeInfo returnType, List<TypeInfo> parameterTypes) {
        assert (!StringUtil.isSuper(name) && !StringUtil.isThis(name));
        assert (parameterTypes != null);
        assert (returnType != null && !parameterTypes.contains(null));
        this.name = MyInterner.intern(name);
        this.isConstructor = "<init>".equals(name);
        this.returnType = returnType;
        this.parameterTypes = Collections.unmodifiableList(parameterTypes);
        this.parameterEquivalence = TypeInfoEquivalence.wrapAll(parameterTypes);
        String returnSignature = returnType.getTypeSignature();
        String paramSignature = LessStrings.toString(parameterTypes, TypeInfo.TO_TYPE_SIGNATURE, new StringJoiner("", "(", ")"));
        this.bytecodeSignature = MyInterner.intern(paramSignature + returnSignature);
        String apexParamNames = LessStrings.toString(parameterTypes, TypeInfo.TO_APEX_NAME, new StringJoiner(", ", "(", ")"));
        String definingTypePlusName = definingType == null ? name : definingType.toString() + "." + name;
        this.apexSignature = MyInterner.intern(returnType + " " + definingTypePlusName + apexParamNames);
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public List<TypeInfo> getParameterTypes() {
        return this.parameterTypes;
    }

    public String getValue() {
        return this.bytecodeSignature;
    }

    public String getApexValue() {
        return this.apexSignature;
    }

    public String getSignatureParameters() {
        return LessStrings.toString(this.parameterTypes, TypeInfo.TO_APEX_NAME, new StringJoiner(", ", "(", ")"));
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.returnType, this.parameterTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equal(this.name, signature.name) && TypeInfoEquivalence.isEquivalent(this.returnType, signature.returnType) && this.parameterEquivalence.equals(signature.parameterEquivalence);
    }

    public String toString() {
        return this.apexSignature;
    }

    public boolean equalsSignature(Signature that) {
        return (this.name != null ? this.name.equalsIgnoreCase(that.name) : that.name == null) && this.parameterEquivalence.equals(that.parameterEquivalence);
    }

    public int hashCodeSignature() {
        return Objects.hashCode(this.name.toLowerCase());
    }
}

