/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.MemberVisitor;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import java.util.List;

public class ReifiedMethodInfo
implements MethodInfo {
    private final MethodInfo unreifiedMethod;
    private final GenericTypeInfo definingType;
    private final TypeInfo returnType;
    private final List<Parameter> parameters;
    private final Signature signature;
    private final boolean needsReturnTypeConversion;

    public ReifiedMethodInfo(MethodInfo unreifiedMethod, TypeInfo returnType, List<Parameter> parameters, GenericTypeInfo definingType) {
        this.unreifiedMethod = unreifiedMethod;
        this.returnType = returnType;
        this.parameters = parameters;
        this.definingType = definingType;
        this.signature = new Signature(unreifiedMethod.getName(), definingType, returnType, Parameter.toType(parameters));
        this.needsReturnTypeConversion = !TypeInfoEquivalence.isEquivalent(returnType, unreifiedMethod.getReturnType());
    }

    @Override
    public Identifier getIdentifier() {
        return this.unreifiedMethod.getIdentifier();
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.unreifiedMethod.getEmitSignature();
    }

    @Override
    public InvocationType getInvocationType() {
        return this.unreifiedMethod.getInvocationType();
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.unreifiedMethod.getJavaSfdcOnlyAnnotation();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isConstructor() {
        return this.unreifiedMethod.isConstructor();
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.unreifiedMethod.isPropertyAccessor();
    }

    @Override
    public boolean isTriggerInvoke() {
        return this.unreifiedMethod.isTriggerInvoke();
    }

    @Override
    public boolean isStaticInitialization() {
        return this.unreifiedMethod.isStaticInitialization();
    }

    @Override
    public String getCanonicalName() {
        return this.unreifiedMethod.getCanonicalName();
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.unreifiedMethod.setCanonicalName(canonicalName);
    }

    @Override
    public MethodInfo getMethodInterface() {
        return this.unreifiedMethod;
    }

    @Override
    public void setMethodInterface(MethodInfo methodInterface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generated getGenerated() {
        return this.unreifiedMethod.getGenerated();
    }

    @Override
    public boolean hasReturnValue() {
        return this.unreifiedMethod.hasReturnValue();
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return this.unreifiedMethod.getAsmMethodBuilder();
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.unreifiedMethod.getAsmMethod();
    }

    @Override
    public String getMangledName() {
        return this.unreifiedMethod.getMangledName();
    }

    @Override
    public String getMangledCanonicalName() {
        return this.unreifiedMethod.getMangledCanonicalName();
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.unreifiedMethod.getProfilingType();
    }

    @Override
    public boolean isDuckTyped() {
        return this.unreifiedMethod.isDuckTyped();
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.unreifiedMethod.getValidators();
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return this.needsReturnTypeConversion;
    }

    @Override
    public String getName() {
        return this.unreifiedMethod.getName();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Member.Type getMemberType() {
        return this.unreifiedMethod.getMemberType();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.unreifiedMethod.getModifiers();
    }

    @Override
    public <T> T accept(MemberVisitor<T> visitor) {
        return this.unreifiedMethod.accept(visitor);
    }

    @Override
    public Loc getLoc() {
        return this.unreifiedMethod.getLoc();
    }

    public String toString() {
        return this.getSignature().toString();
    }
}

