/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsResultWithError;
import apex.jorje.services.I18nSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MethodTableTest {
    private static final MethodInfo FOO_INTEGER_METHOD = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private static final MethodInfo FOO_STRING_METHOD = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.STRING).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    private MethodTable methods;

    @BeforeMethod
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.methods = new StandardMethodTable();
    }

    @Test
    public void testAddLookup() {
        this.methods.addNoDuplicatesAllowed(FOO_INTEGER_METHOD).throwIfError();
        MatcherAssert.assertThat((Object)this.methods.get(FOO_INTEGER_METHOD.getSignature()), (Matcher)Matchers.is((Object)FOO_INTEGER_METHOD));
        MatcherAssert.assertThat((Object)this.methods.get(SignatureFactory.create("FOO_ID", (TypeInfo)TypeInfos.INTEGER, TypeInfos.INTEGER)), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAddDuplicatesAllowed() {
        this.methods.addNoDuplicatesAllowed(FOO_INTEGER_METHOD).throwIfError();
        Result<Void> result = this.methods.addNoDuplicatesAllowed(FOO_INTEGER_METHOD);
        MatcherAssert.assertThat(result, IsResultWithError.error(I18nSupport.getLabel("method.already.exists", FOO_INTEGER_METHOD.getSignature().getName(), FOO_INTEGER_METHOD.getSignature().getValue(), "Integer")));
    }

    @Test
    public void testAddNoDuplicatesAllowed() {
        this.methods.addDuplicatesAllowed(FOO_INTEGER_METHOD).throwIfError();
        this.methods.addDuplicatesAllowed(FOO_INTEGER_METHOD).throwIfError();
    }

    @Test
    public void testAddNoDuplicatesDifferentReturnType() {
        this.methods.addDuplicatesAllowed(FOO_INTEGER_METHOD).throwIfError();
        Result<Void> result = this.methods.addDuplicatesAllowed(FOO_STRING_METHOD);
        MatcherAssert.assertThat(result, IsResultWithError.error(I18nSupport.getLabel("method.types.clash", FOO_STRING_METHOD.getReturnType(), FOO_INTEGER_METHOD.getReturnType(), "Integer")));
    }
}

