/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import com.google.common.collect.Iterables;
import java.util.Collections;

public class MethodNameMangler {
    static String mangle(TypeInfo type) {
        return TypeInfoUtil.containsPlaceholders(type.getTypeArguments()) ? MethodNameMangler.mangle(TypeNameUtil.createApexNameWithPlaceHolders(type, type.getTypeArguments())) : MethodNameMangler.mangle(type.getApexName());
    }

    static String mangle(String name) {
        StringBuilder builder = new StringBuilder();
        block8: for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '<': {
                    builder.append("$$l");
                    continue block8;
                }
                case '>': {
                    builder.append("$$r");
                    continue block8;
                }
                case ',': {
                    builder.append("$$c");
                    continue block8;
                }
                case '.': {
                    builder.append("$$d");
                    continue block8;
                }
                case ':': {
                    builder.append("$$o");
                    continue block8;
                }
                case ' ': {
                    continue block8;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }

    private static String createMangledName(String name, Signature signature) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("_r").append(MethodNameMangler.mangle(signature.getReturnType()));
        for (int i = 0; i < signature.getParameterTypes().size(); ++i) {
            sb.append("_").append(i).append(MethodNameMangler.mangle(signature.getParameterTypes().get(i)));
        }
        assert (sb.length() < 65536) : "The java class file format has a max method length limit of 64k";
        return sb.toString();
    }

    static boolean hasFastCallType(Signature signature) {
        for (TypeInfo type : Iterables.concat(Collections.singletonList(signature.getReturnType()), signature.getParameterTypes())) {
            if (!TypeInfoUtil.isFastCallType(type)) continue;
            return true;
        }
        return false;
    }

    public static String getMangledName(MethodInfo methodInfo, String name) {
        return MethodNameMangler.isMangledName(methodInfo) ? MethodNameMangler.createMangledName(name, methodInfo.getSignature()) : name;
    }

    public static boolean isMangledName(MethodInfo methodInfo) {
        return methodInfo.getGenerated().isUserDefined && !methodInfo.isConstructor() && MethodNameMangler.hasFastCallType(methodInfo.getSignature());
    }

    public static String getGenericInterfaceMangled(TypeInfo interfaceType, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(MethodNameMangler.mangle(interfaceType));
        sb.append("_i");
        sb.append(name);
        assert (sb.length() < 65536) : "The java class file format has a max method length limit of 64k";
        return sb.toString();
    }
}

