/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.tester.TestModifierGroups;
import apex.jorje.semantic.tester.matchers.IsType;
import com.google.common.collect.Lists;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class MethodInfoTest {
    private static final List<TypeInfo> TYPES = Lists.newArrayList(TypeInfos.INTEGER, TypeInfos.INTEGER);
    private static final Signature SIGNATURE = SignatureFactory.create(JadtTester.FOO_ID.value, (TypeInfo)TypeInfos.INTEGER, TYPES);

    @Test
    public void testNewMethod() {
        MethodInfo method = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setNamedParameterTypes(TypeInfos.INTEGER, TypeInfos.INTEGER).setReturnType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        MatcherAssert.assertThat((Object)method.getName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        MatcherAssert.assertThat((Object)method.getLoc(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.loc));
        MatcherAssert.assertThat((Object)method.getReturnType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat(method.getParameterTypes(), (Matcher)Matchers.is(TYPES));
        MatcherAssert.assertThat((Object)method.isConstructor(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)method.getDefiningType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)method.getSignature(), (Matcher)Matchers.is((Object)SIGNATURE));
        MatcherAssert.assertThat((Object)((Object)method.getGenerated()), (Matcher)Matchers.is((Object)((Object)Generated.USER)));
        MatcherAssert.assertThat((Object)method.isStaticInitialization(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)method.getCanonicalName(), (Matcher)Matchers.is((Object)JadtTester.FOO_ID.value));
        method.setCanonicalName("FOO");
        MatcherAssert.assertThat((Object)method.getCanonicalName(), (Matcher)Matchers.is((Object)"FOO"));
    }

    @Test
    public void testStaticInvocationType() {
        MethodInfo method = StandardMethodInfo.builder().setModifiers(ModifierGroups.GLOBAL_STATIC).setDefiningType(TypeInfos.INTEGER).setReturnType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).build();
        MatcherAssert.assertThat((Object)((Object)method.getInvocationType()), (Matcher)Matchers.is((Object)((Object)InvocationType.STATIC)));
    }

    @Test
    public void testConstructorSpecialInvocationType() {
        MethodInfo method = StandardMethodInfo.builder().setModifiers(TestModifierGroups.PUBLIC).setDefiningType(TypeInfos.INTEGER).setConstructor().setName(JadtTester.FOO_ID).setGenerated(Generated.USER).build();
        MatcherAssert.assertThat((Object)((Object)method.getInvocationType()), (Matcher)Matchers.is((Object)((Object)InvocationType.SPECIAL)));
    }

    @Test
    public void testVirtualInvocationType() {
        MethodInfo method = StandardMethodInfo.builder().setModifiers(TestModifierGroups.PUBLIC).setDefiningType(TypeInfos.INTEGER).setReturnType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).build();
        MatcherAssert.assertThat((Object)((Object)method.getInvocationType()), (Matcher)Matchers.is((Object)((Object)InvocationType.VIRTUAL)));
    }

    @Test
    public void testPropertyAccessorSpecialInvocationType() {
        MethodInfo method = StandardMethodInfo.builder().setModifiers(TestModifierGroups.PUBLIC).setDefiningType(TypeInfos.INTEGER).setReturnType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setGenerated(Generated.USER).setPropertyAccessor().build();
        MatcherAssert.assertThat((Object)((Object)method.getInvocationType()), (Matcher)Matchers.is((Object)((Object)InvocationType.SPECIAL)));
    }

    @Test
    public void testNewConstructor() {
        MethodInfo method = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName("<init>").setConstructor().setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        MatcherAssert.assertThat((Object)method.getName(), (Matcher)Matchers.is((Object)"<init>"));
        MatcherAssert.assertThat((Object)method.getReturnType(), IsType.isType(TypeInfos.VOID));
        MatcherAssert.assertThat(method.getParameters(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(method.getParameterTypes(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)method.isConstructor(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)method.isStaticInitialization(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)method.getDefiningType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)method.getSignature().getValue(), (Matcher)Matchers.is((Object)"()V"));
    }

    @Test
    public void testStaticInitialization() {
        MethodInfo method = StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName("<clinit>").setReturnType(TypeInfos.VOID).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        MatcherAssert.assertThat((Object)method.isStaticInitialization(), (Matcher)Matchers.is((Object)true));
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoClassType() {
        StandardMethodInfo.builder().setName(JadtTester.FOO_ID).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoName() {
        StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testNoModifiers() {
        StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).build();
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGeneratedNotSet() {
        StandardMethodInfo.builder().setDefiningType(TypeInfos.INTEGER).setName(JadtTester.FOO_ID).setReturnType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    }

    @Test
    public void testInterfaceImplementedMethodGeneratesINVOKEINTERFACE() {
        StandardTypeInfo someInterface = (StandardTypeInfo)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("IFoo")).setUnitType(UnitType.INTERFACE)).buildResolved();
        MethodInfo method = StandardMethodInfo.builder().setGenerated(Generated.USER).setDefiningType(someInterface).setName("Foo").setReturnType(TypeInfos.VOID).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        AsmMethod emitMethod = method.getAsmMethod();
        MatcherAssert.assertThat((Object)emitMethod.opcode, (Matcher)Matchers.is((Object)185));
    }

    @Test
    public void testNonInterfaceImplementedMethodGeneratesINVOKEVIRTUAL() {
        StandardTypeInfo someInterface = (StandardTypeInfo)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexBytecodeName("CFoo")).setUnitType(UnitType.CLASS)).buildResolved();
        MethodInfo method = StandardMethodInfo.builder().setGenerated(Generated.USER).setDefiningType(someInterface).setName("Foo").setReturnType(TypeInfos.VOID).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        AsmMethod emitMethod = method.getAsmMethod();
        MatcherAssert.assertThat((Object)emitMethod.opcode, (Matcher)Matchers.is((Object)182));
    }
}

