/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.Version;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MapMethodTableTest {
    private static final TypeInfo DOUBLE_TO_OBJECT = GenericTypeInfoFactory.createMap(TypeInfos.DOUBLE, TypeInfos.OBJECT);
    private static final TypeInfo OBJECT_TO_DOUBLE = GenericTypeInfoFactory.createMap(TypeInfos.OBJECT, TypeInfos.DOUBLE);
    private static final TypeInfo DOUBLE_TO_DOUBLE = GenericTypeInfoFactory.createMap(TypeInfos.DOUBLE, TypeInfos.DOUBLE);

    @DataProvider
    Object[][] putNotAmbiguousData() {
        return new Object[][]{{DOUBLE_TO_OBJECT}, {OBJECT_TO_DOUBLE}, {DOUBLE_TO_DOUBLE}};
    }

    @Test(dataProvider="putNotAmbiguousData")
    public void testPutNotAmbiguous(TypeInfo mapType) {
        Result<MethodInfo> method = mapType.methods().getApproximate(Version.CURRENT, SignatureFactory.create("put", (TypeInfo)TypeInfos.VOID, InternalTypeInfos.NULL, InternalTypeInfos.NULL), MethodLookupMode.INSTANCE);
        MatcherAssert.assertThat((Object)method.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @DataProvider
    Object[][] putDecimalKey() {
        return new Object[][]{{DOUBLE_TO_OBJECT}, {DOUBLE_TO_DOUBLE}};
    }

    @Test(dataProvider="putDecimalKey")
    public void testPutDecimalKey(TypeInfo mapType) {
        Result<MethodInfo> method = mapType.methods().getApproximate(Version.CURRENT, SignatureFactory.create("put", (TypeInfo)TypeInfos.VOID, TypeInfos.DECIMAL, InternalTypeInfos.NULL), MethodLookupMode.INSTANCE);
        MatcherAssert.assertThat((Object)method.isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @DataProvider
    Object[][] putDecimalValue() {
        return new Object[][]{{OBJECT_TO_DOUBLE}, {DOUBLE_TO_DOUBLE}};
    }

    @Test(dataProvider="putDecimalValue")
    public void testPutDecimalValue(TypeInfo mapType) {
        Result<MethodInfo> method = mapType.methods().getApproximate(Version.CURRENT, SignatureFactory.create("put", (TypeInfo)TypeInfos.VOID, InternalTypeInfos.NULL, TypeInfos.DECIMAL), MethodLookupMode.INSTANCE);
        MatcherAssert.assertThat((Object)method.isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

