/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.matchers.IsType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.commons.GeneratorAdapter;

public class LocalInfoTest {
    private static final LocalInfo LOCAL_VARIABLE = LocalInfo.builder().setName("foo").setDefiningType(InternalTypeInfos.APEX_OBJECT).setType(TypeInfos.INTEGER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
    @Mock
    private GeneratorAdapter generatorAdapter;
    private Emitter emitter;

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        MethodInfo methodInfo = StandardMethodInfo.builder().setReturnType(TypeInfos.INTEGER).setName("dummy").setDefiningType(TypeInfos.INTEGER).setGenerated(Generated.USER).setModifiers(ModifierGroups.STATEMENT_EXECUTED).build();
        MethodStack.MethodContext method = new MethodStack.MethodContext(methodInfo, this.generatorAdapter);
        this.emitter = new Emitter();
        this.emitter.getMethodStack().push(method);
    }

    @Test
    public void testPosition() {
        boolean expected = false;
        MatcherAssert.assertThat((Object)LOCAL_VARIABLE.getPosition(this.emitter), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)LOCAL_VARIABLE.getPosition(this.emitter), (Matcher)Matchers.is((Object)0));
        LOCAL_VARIABLE.getPosition(this.emitter);
        ((GeneratorAdapter)Mockito.verify((Object)this.generatorAdapter, (VerificationMode)Mockito.times((int)1))).visitLabel((Label)org.mockito.Matchers.any(Label.class));
        ((GeneratorAdapter)Mockito.verify((Object)this.generatorAdapter, (VerificationMode)Mockito.times((int)1))).visitLocalVariable((String)org.mockito.Matchers.eq((Object)LOCAL_VARIABLE.getName()), (String)org.mockito.Matchers.eq((Object)LOCAL_VARIABLE.getType().getTypeSignature()), (String)org.mockito.Matchers.isNull(), (Label)org.mockito.Matchers.any(Label.class), (Label)org.mockito.Matchers.any(Label.class), org.mockito.Matchers.eq((int)0));
    }

    @Test
    public void testGetters() {
        MatcherAssert.assertThat((Object)LOCAL_VARIABLE.getName(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)LOCAL_VARIABLE.getType(), IsType.isType(TypeInfos.INTEGER));
        MatcherAssert.assertThat((Object)LOCAL_VARIABLE.getModifiers(), (Matcher)Matchers.is((Object)ModifierGroups.STATEMENT_EXECUTED));
    }
}

