/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.exception;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Errors {
    private final List<CompilationException> errors = new ArrayList<CompilationException>();
    private final Set<AstNode> invalidNodes = new HashSet<AstNode>();

    public void clear() {
        this.errors.clear();
        this.invalidNodes.clear();
    }

    public void addAll(Collection<? extends CompilationException> errors) {
        this.errors.addAll(errors);
    }

    public List<CompilationException> get() {
        return this.errors;
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public void markInvalid(String label) {
        this.markInvalid(Loc._SyntheticLoc(), label);
    }

    public void markInvalid(Loc loc, String label) {
        this.errors.add(new SemanticException(loc, label));
    }

    public void markInvalid(AstNode node) {
        this.invalidNodes.add(node);
    }

    public void markInvalid(AstNode node, String message) {
        this.errors.add(new SemanticException(node.getLoc(), message));
        this.invalidNodes.add(node);
    }

    public void markInvalid(AstNode node, List<String> messages) {
        this.markInvalid(node, node.getLoc(), messages);
    }

    public void markInvalid(AstNode node, Loc loc, String messages) {
        this.markInvalid(node, loc, ImmutableList.of(messages));
    }

    public void markInvalid(AstNode node, Loc loc, List<String> messages) {
        List errors = messages.stream().map(message -> new SemanticException(loc, (String)message)).collect(MoreIterables.toUnmodifiableList(messages.size()));
        this.markInvalid(node, errors);
    }

    public void markInvalid(AstNode node, Collection<? extends CompilationException> errors) {
        if (!errors.isEmpty()) {
            this.errors.addAll(errors);
            this.invalidNodes.add(node);
        }
    }

    public boolean addIfError(AstNode node, Result<?> result) {
        return this.addIfError(node, node.getLoc(), result);
    }

    public boolean addIfError(AstNode node, Loc loc, Result<?> result) {
        if (result.hasError()) {
            this.markInvalid(node, loc, result.getError());
            return true;
        }
        return false;
    }

    public boolean addIfError(AstNode node, Result<?> result, I18nSupplier absentMessageSupplier) {
        return this.addIfError(node, node.getLoc(), result, absentMessageSupplier);
    }

    private boolean addIfError(AstNode node, Loc loc, Result<?> result, I18nSupplier absentMessageSupplier) {
        if (result.hasError()) {
            this.markInvalid(node, loc, result.getError());
            return true;
        }
        if (result.absent()) {
            this.markInvalid(node, loc, absentMessageSupplier.get());
            return true;
        }
        return false;
    }

    public void throwIfAny() {
        if (!this.isEmpty()) {
            throw this.errors.get(0);
        }
    }

    public <T extends AstNode> boolean isInvalid(Collection<T> nodes, AstNode ... moreNodes) {
        return this.isInvalid(nodes) || this.isInvalid(moreNodes);
    }

    public boolean isInvalid(AstNode node) {
        return this.invalidNodes.contains(node);
    }

    public boolean isInvalid(AstNode ... nodes) {
        return this.isInvalid(Arrays.asList(nodes));
    }

    public <T extends AstNode> boolean isInvalid(Collection<T> nodes) {
        for (AstNode node : nodes) {
            if (!this.invalidNodes.contains(node)) continue;
            return true;
        }
        return false;
    }
}

