/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestSymbolProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.testng.annotations.Test;

public class TwoStageSourceTest {
    @Test
    public void testFieldRef() {
        SourceFile firstClass = SourceFile.builder().setBody("public class FieldDef { private FieldDefData fdd; }").build();
        SourceFile systemClass = SourceFile.builder().setBody("public class FieldDefData {}").setKnownName("FieldDefData").build();
        this.runScenario(Collections.singletonList(firstClass), systemClass);
    }

    @Test
    public void testParentRef() {
        SourceFile firstClass = SourceFile.builder().setBody("public class B implements A<String> {}").setTrusted(true).build();
        SourceFile systemClass = SourceFile.builder().setBody("public interface A<T> {}").setKnownName("A").setTrusted(true).build();
        this.runScenario(Collections.singletonList(firstClass), systemClass);
    }

    private void runScenario(Collection<SourceFile> sources, SourceFile ... builtInSources) {
        CompilationInput input = new CompilationInput(sources, new TestSymbolProvider().addAdditionalFiles(builtInSources), new TestAccessEvaluator(), new TestQueryValidators.Noop(), null);
        ApexCompiler compiler = ApexCompiler.builder().setInput(input).build();
        List<CompilationOutput> output = compiler.compileThrowErrors();
        MatcherAssert.assertThat(output, (Matcher)IsCollectionWithSize.hasSize((int)(sources.size() + builtInSources.length)));
    }
}

