/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.StructuredVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class StructuredVersionTest {
    private static final StructuredVersion V12 = new StructuredVersion(1, 2);
    private static final StructuredVersion V13 = new StructuredVersion(1, 3);
    private static final StructuredVersion V21 = new StructuredVersion(2, 1);
    private static final StructuredVersion V12_OTHER_INSTANCE = new StructuredVersion(1, 2);

    @Test
    public void compareToLess() {
        MatcherAssert.assertThat((Object)V12.compareTo(V21), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void compareToMore() {
        MatcherAssert.assertThat((Object)V21.compareTo(V12), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void compareToSameMajor() {
        MatcherAssert.assertThat((Object)V12.compareTo(V13), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void compareToEquals() {
        MatcherAssert.assertThat((Object)V12.compareTo(V12_OTHER_INSTANCE), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void compareToMin() {
        MatcherAssert.assertThat((Object)V12.compareTo(StructuredVersion.DEFAULT_MIN_VERSION), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void compareToMinOtherWay() {
        MatcherAssert.assertThat((Object)StructuredVersion.DEFAULT_MIN_VERSION.compareTo(V12), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void compareToMax() {
        MatcherAssert.assertThat((Object)V12.compareTo(StructuredVersion.DEFAULT_MAX_VERSION), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void compareToMaxOtherWay() {
        MatcherAssert.assertThat((Object)StructuredVersion.DEFAULT_MAX_VERSION.compareTo(V12), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

