/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import java.util.Objects;

public class StructuredVersion
implements Comparable<StructuredVersion> {
    public static final StructuredVersion DEFAULT_MIN_VERSION = new StructuredVersion(0, 0);
    public static final StructuredVersion DEFAULT_MAX_VERSION = new StructuredVersion(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final int majorVersion;
    private final int minorVersion;

    public StructuredVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredVersion other = (StructuredVersion)obj;
        return Objects.equals(this.majorVersion, other.majorVersion) && Objects.equals(this.minorVersion, other.minorVersion);
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion;
    }

    @Override
    public int compareTo(StructuredVersion other) {
        return this.majorVersion == other.majorVersion ? this.minorVersion - other.minorVersion : this.majorVersion - other.majorVersion;
    }
}

