/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.Position;
import apex.jorje.semantic.compiler.SourceInfo;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.services.Version;
import java.util.Collections;
import java.util.Map;

public class SourceFile
implements SourceInfo {
    private final String body;
    private final Version version;
    private final Namespace namespace;
    private final boolean isTrusted;
    private final boolean isFileBased;
    private final String allPackageId;
    private final int sizeLimit;
    private final String knownName;
    private final Map<Namespace, StructuredVersion> referencedPackageVersions;
    private final Map<Position, StructuredVersionRange> exportedPackageVersions;

    private SourceFile(Builder builder) {
        this.body = builder.body;
        this.version = builder.version;
        this.namespace = builder.namespace;
        this.isTrusted = builder.isTrusted;
        this.isFileBased = builder.isFileBased;
        this.allPackageId = builder.allPackageId;
        this.sizeLimit = builder.sizeLimit;
        this.knownName = builder.knownName;
        this.referencedPackageVersions = builder.referencedPackageVersions;
        this.exportedPackageVersions = builder.exportedPackageVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBody() {
        return this.body;
    }

    public Version getVersion() {
        return this.version;
    }

    public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
        return this.referencedPackageVersions;
    }

    public Map<Position, StructuredVersionRange> getExportedPackageVersions() {
        return this.exportedPackageVersions;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isTrusted() {
        return this.isTrusted;
    }

    @Override
    public boolean isFileBased() {
        return this.isFileBased;
    }

    public String getAllPackageId() {
        return this.allPackageId;
    }

    public String toString() {
        return this.body;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public String getKnownName() {
        return this.knownName;
    }

    public Builder copy() {
        return new Builder().setSeed(this);
    }

    public static class Builder {
        private String body = "";
        private Version version = Version.CURRENT;
        private Namespace namespace = Namespaces.EMPTY;
        private boolean isTrusted = false;
        private boolean isFileBased = false;
        private String allPackageId = null;
        private int sizeLimit = Integer.MAX_VALUE;
        private String knownName = "";
        private Map<Namespace, StructuredVersion> referencedPackageVersions = Collections.emptyMap();
        private Map<Position, StructuredVersionRange> exportedPackageVersions = Collections.emptyMap();

        private Builder() {
        }

        public SourceFile build() {
            assert (this.isFileBased == this.isTrusted || !this.isFileBased) : "source cannot be file based and not trusted";
            return new SourceFile(this);
        }

        public Builder setSeed(SourceFile sourceFile) {
            this.allPackageId = sourceFile.allPackageId;
            this.isTrusted = sourceFile.isTrusted;
            this.isFileBased = sourceFile.isFileBased;
            this.namespace = sourceFile.namespace;
            this.body = sourceFile.body;
            this.version = sourceFile.version;
            this.sizeLimit = sourceFile.sizeLimit;
            this.knownName = sourceFile.knownName;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder setReferencedPackageVersions(Map<Namespace, StructuredVersion> referencedPackageVersions) {
            this.referencedPackageVersions = referencedPackageVersions;
            return this;
        }

        public Builder setExportedPackageVersions(Map<Position, StructuredVersionRange> exportedPackageVersions) {
            this.exportedPackageVersions = exportedPackageVersions;
            return this;
        }

        public Builder setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setTrusted(boolean isTrusted) {
            this.isTrusted = isTrusted;
            return this;
        }

        public Builder setFileBased(boolean isFileBased) {
            this.isFileBased = isFileBased;
            return this;
        }

        public Builder setAllPackageId(String allPackageId) {
            this.allPackageId = allPackageId;
            return this;
        }

        public Builder setSizeLimit(int sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }

        @SfdcCalled
        public Builder setKnownName(String knownName) {
            this.knownName = knownName;
            return this;
        }
    }
}

