/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.Namespace;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Namespaces {
    public static final Namespace SYSTEM = Namespaces.create("System", null);
    public static final Namespace SCHEMA = Namespaces.create("Schema", null);
    public static final Namespace VF_COMPONENT = Namespaces.create("Component", null);
    public static final Namespace VF = Namespaces.create("c", null);
    public static final Namespace APEX_PAGES = Namespaces.create("ApexPages", null);
    public static final Namespace APEX = Namespaces.create("Apex", null);
    public static final Namespace EMPTY = Namespaces.create(null, null);
    public static final Namespace DATABASE = Namespaces.create("Database", null);
    public static final Namespace FLOW = Namespaces.create("Flow", null);
    public static final Namespace CONNECT_API = Namespaces.create("ConnectApi", null);
    public static final Namespace CUSTOM_METADATA = Namespaces.create("CustomMetadata", null);
    private static final Pattern NAMESPACE = Pattern.compile("([^_]*)__([^_]*)");
    private static final Map<String, Namespace> STRING_TO_NAMESPACE = Maps.newHashMap();

    public static Namespace parse(String fullNamespace) {
        if (STRING_TO_NAMESPACE.containsKey(fullNamespace)) {
            return STRING_TO_NAMESPACE.get(fullNamespace);
        }
        Matcher m = NAMESPACE.matcher(fullNamespace);
        Namespace namespace = m.matches() ? Namespaces.create(m.group(1), m.group(2)) : Namespaces.create(fullNamespace);
        STRING_TO_NAMESPACE.put(fullNamespace, namespace);
        return namespace;
    }

    public static Namespace parse(String global, String module) {
        assert (!Strings.isNullOrEmpty(global) && !Strings.isNullOrEmpty(module));
        String key = global + "__" + module;
        if (STRING_TO_NAMESPACE.containsKey(key)) {
            return STRING_TO_NAMESPACE.get(key);
        }
        Namespace namespace = Namespaces.create(global, module);
        STRING_TO_NAMESPACE.put(key, namespace);
        return namespace;
    }

    public static Namespace create(String global) {
        return Namespaces.create(global, null);
    }

    public static Namespace create(String global, String module) {
        return new Namespace(global, module);
    }
}

