/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.MyInterner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Strings;

public class Namespace {
    private final String global;
    private final String module;
    private final String name;
    private final String nameLowerCase;

    Namespace(String global, String module) {
        this.global = MyInterner.intern(MoreObjects.firstNonNull(global, ""));
        this.module = MyInterner.intern(MoreObjects.firstNonNull(module, ""));
        this.name = MyInterner.intern(Strings.isNullOrEmpty(module) ? this.global : this.global + "__" + this.module);
        this.nameLowerCase = MyInterner.intern(this.name.toLowerCase());
    }

    public static boolean isEmptyOrNull(Namespace namespace) {
        return namespace == null || namespace.equals(Namespaces.EMPTY);
    }

    public static boolean equals(TypeInfo left, TypeInfo right) {
        assert (left != null && right != null && left.getNamespace() != null && right.getNamespace() != null);
        return left.getNamespace().equals(right.getNamespace());
    }

    public String getNameLower() {
        return this.nameLowerCase;
    }

    public String getGlobal() {
        return this.global;
    }

    public String getModule() {
        return this.module;
    }

    public int hashCode() {
        return Objects.hashCode(this.nameLowerCase);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return Objects.equal(this.nameLowerCase, namespace.nameLowerCase);
    }

    public final String toString() {
        return this.name;
    }

    public boolean equalsGlobal(Namespace other) {
        return !(this.global != null && other.global != null ? !this.global.equalsIgnoreCase(other.global) : this.global != null || other.global != null);
    }
}

