/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.SymbolVisitor;
import apex.jorje.semantic.ast.visitor.reference.ReferenceVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerOperation;

public final class CompilerStage
extends Enum<CompilerStage> {
    public static final /* enum */ CompilerStage WAITING = new CompilerStage();
    public static final /* enum */ CompilerStage PARSE = new CompilerStage((context, codeUnit) -> codeUnit.parse());
    public static final /* enum */ CompilerStage REPARSE = new CompilerStage((context, codeUnit) -> {
        if (codeUnit.updateVersion()) {
            codeUnit.reparse();
        }
        context.getSymbolResolver().getSymbolProvider().reportParsed(codeUnit);
    });
    public static final /* enum */ CompilerStage SYMBOLS = new CompilerStage(new CompilerOperation(){
        private final SymbolVisitor symbolVisitor = new SymbolVisitor();

        @Override
        public void invoke(CompilerContext context, CodeUnit codeUnit) {
            codeUnit.traverse(this.symbolVisitor, SymbolScope.create(context, codeUnit));
            if (codeUnit.getErrors().isEmpty()) {
                context.addTypeInfoCodeUnit(codeUnit.getType(), codeUnit);
            }
        }
    });
    public static final /* enum */ CompilerStage PARENT = new CompilerStage((context, codeUnit) -> codeUnit.traverse(context.getParentVisitor(), SymbolScope.create(context, codeUnit)));
    public static final /* enum */ CompilerStage MEMBER_RESOLVE = new CompilerStage((context, codeUnit) -> codeUnit.traverse(context.getMemberResolveVisitor(), SymbolScope.create(context, codeUnit)));
    public static final /* enum */ CompilerStage POST_TYPE_RESOLVE = new CompilerStage((context, codeUnit) -> codeUnit.traverse(context.getPostTypeResolveVisitor(), SymbolScope.create(context, codeUnit)));
    public static final /* enum */ CompilerStage VALIDATE = new CompilerStage((context, codeUnit) -> codeUnit.validate(context.getSymbolResolver()));
    public static final /* enum */ CompilerStage ADDITIONAL_VALIDATE = new CompilerStage((context, codeUnit) -> {
        if (context.getAdditionalPassVisitor() != null) {
            codeUnit.additionalValidate(context.getAdditionalPassVisitor());
        }
    });
    public static final /* enum */ CompilerStage REFERENCES = new CompilerStage((context, codeUnit) -> {
        if (codeUnit.getErrors().isEmpty()) {
            ReferenceVisitor referenceVisitor = new ReferenceVisitor(codeUnit.getType(), context.getTypeInfoToCodeUnit());
            codeUnit.traverse(referenceVisitor, SymbolScope.create(context, codeUnit));
            codeUnit.setReferences(referenceVisitor.getReferenceDependencyMap());
        }
    });
    public static final /* enum */ CompilerStage EMIT = new CompilerStage((context, codeUnit) -> {
        Emitter emitter = context.getEmitter();
        emitter.setCodeUnit(codeUnit);
        codeUnit.emit(context.getEmitter());
        emitter.setCodeUnit(null);
    });
    private final CompilerOperation operation;
    private static final /* synthetic */ CompilerStage[] $VALUES;

    public static CompilerStage[] values() {
        return (CompilerStage[])$VALUES.clone();
    }

    public static CompilerStage valueOf(String name) {
        return Enum.valueOf(CompilerStage.class, name);
    }

    private CompilerStage() {
        this(null);
    }

    private CompilerStage(CompilerOperation operation) {
        this.operation = operation;
    }

    CompilerOperation getOperation() {
        assert (this.operation != null) : "trying to operate a stage with no operation: " + (Object)((Object)this);
        return this.operation;
    }

    CompilerStage getPrevious() {
        int targetOrdinal = this.ordinal() - 1;
        assert (targetOrdinal >= 0);
        return CompilerStage.values()[targetOrdinal];
    }

    CompilerStage getNext() {
        int targetOrdinal = this.ordinal() + 1;
        if (targetOrdinal >= CompilerStage.values().length) {
            return null;
        }
        return CompilerStage.values()[targetOrdinal];
    }

    static {
        $VALUES = new CompilerStage[]{WAITING, PARSE, REPARSE, SYMBOLS, PARENT, MEMBER_RESOLVE, POST_TYPE_RESOLVE, VALIDATE, ADDITIONAL_VALIDATE, REFERENCES, EMIT};
    }
}

