/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.util;

import apex.jorje.semantic.common.util.StringUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StringUtilTest {
    @DataProvider
    Object[][] isSuperData() {
        return new Object[][]{{"super", true}, {"SUPER", true}, {"sUPEr", true}, {"foo", false}, {null, false}};
    }

    @Test(dataProvider="isSuperData")
    public void testIsSuper(String input, boolean expected) {
        MatcherAssert.assertThat((Object)StringUtil.isSuper(input), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] isThisData() {
        return new Object[][]{{"this", true}, {"THIS", true}, {"tHIs", true}, {"foo", false}, {null, false}};
    }

    @Test(dataProvider="isThisData")
    public void testIsThis(String input, boolean expected) {
        MatcherAssert.assertThat((Object)StringUtil.isThis(input), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] isLowerCaseData() {
        return new Object[][]{{"asdf", true}, {"asdf<>$_/\\", true}, {"Asdf", false}, {null, false}};
    }

    @Test(dataProvider="isLowerCaseData")
    public void testIsLowerCase(String input, boolean expected) {
        MatcherAssert.assertThat((Object)StringUtil.isLowerCase(input), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] templateData() {
        return new Object[][]{{"foo bar", ImmutableMap.of("nope", "you"), "foo bar"}, {"foo bar", ImmutableMap.of("foo", "effewe"), "effewe bar"}, {"foo bar", ImmutableMap.of("foo", "eff", "bar", "ewe"), "eff ewe"}, {"foo bar", ImmutableMap.of("foo", "eff", "foobar", "ewe"), "eff bar"}};
    }

    @Test(dataProvider="templateData")
    public void testTemplate(String s, Map<String, String> tokens, String expected) {
        MatcherAssert.assertThat((Object)new StringUtil.Template(tokens).match(s), (Matcher)Is.is((Object)expected));
    }

    @DataProvider
    Object[][] toBytecodeNameData() {
        return new Object[][]{{InnerClass.class, "apex/jorje/semantic/common/util/StringUtilTest$InnerClass"}, {Map.class, "java/util/Map"}, {Object.class, "java/lang/Object"}, {StringUtil.class, "apex/jorje/semantic/common/util/StringUtil"}};
    }

    @Test(dataProvider="toBytecodeNameData")
    public void testToBytecodeName(Class<?> clazz, String name) {
        MatcherAssert.assertThat((Object)StringUtil.toBytecodeName(clazz), (Matcher)Is.is((Object)name));
    }

    private static class InnerClass {
        private InnerClass() {
        }
    }
}

