/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.util;

import apex.jorje.data.ast.Identifier;
import apex.jorje.services.MyInterner;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtil {
    public static final Function<String, String> TO_LOWER_NAME = String::toLowerCase;
    public static final Function<Identifier, String> IDENTIFIER_TO_NAME = name -> name.value;

    private StringUtil() {
    }

    public static String toBytecodeName(Class<?> clazz) {
        return MyInterner.intern(clazz.getName().replace('.', '/'));
    }

    public static boolean isSuper(String s) {
        return "super".equalsIgnoreCase(s);
    }

    public static boolean isThis(String s) {
        return "this".equalsIgnoreCase(s);
    }

    public static boolean isLowerCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isAlphabetic(s.charAt(i)) || Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class Template {
        private final Pattern pattern;
        private final Map<String, String> tokens;

        public Template(Map<String, String> tokens) {
            this(tokens, Pattern.compile(tokens.keySet().stream().collect(Collectors.joining("|", "(", ")"))));
        }

        public Template(Map<String, String> tokens, Pattern pattern) {
            this.pattern = pattern;
            this.tokens = tokens;
        }

        public String match(String s) {
            Matcher matcher = this.pattern.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, this.tokens.get(matcher.group(1)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

