/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterator;

import apex.jorje.semantic.common.iterator.Pair;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NotEqualPairIterator<Left, Right>
implements Iterator<Pair<Left, Right>> {
    private final Iterator<Left> left;
    private final Iterator<Right> right;

    private NotEqualPairIterator(Iterator<Left> left, Iterator<Right> right) {
        this.left = left;
        this.right = right;
    }

    public static <Left, Right> Iterable<Pair<Left, Right>> iterable(Iterable<Left> left, Iterable<Right> right) {
        return () -> new NotEqualPairIterator(left.iterator(), right.iterator());
    }

    @Override
    public boolean hasNext() {
        return this.left.hasNext() || this.right.hasNext();
    }

    @Override
    public Pair<Left, Right> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new Pair<Left, Right>(this.next(this.left), this.next(this.right));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove via iterator");
    }

    private <T> T next(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }
}

