/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.tester.matchers.IterableMatchers;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MoreIterablesTest {
    @Mock
    private TypeInfo type;
    @Mock
    private TypeInfo superType;
    @Mock
    private TypeInfo interfaceType;
    @Mock
    private ParentTable parents;
    @Mock
    private MethodInfo method;

    @Test
    public void testEnsureNone() throws Exception {
        MatcherAssert.assertThat((Object)MoreIterables.ensureNone(ImmutableList.of("foo"), Predicate.isEqual("foo")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)MoreIterables.ensureNone(ImmutableList.of("foo"), Predicate.isEqual("bar")), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testEnsureAny() throws Exception {
        MatcherAssert.assertThat((Object)MoreIterables.ensureAny(ImmutableList.of("foo"), Predicate.isEqual("foo")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MoreIterables.ensureAny(ImmutableList.of("foo"), Predicate.isEqual("bar")), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testLinkedHashSet() throws Exception {
        LinkedHashSet<String> set = MoreIterables.linkedHashSet("a", "b", "c", "d");
        MatcherAssert.assertThat(set, (Matcher)Matchers.contains((Object[])new String[]{"a", "b", "c", "d"}));
    }

    @DataProvider
    Object[][] parentTypesData() {
        MockitoAnnotations.initMocks((Object)this);
        return new Object[][]{{null, Collections.emptySet(), Collections.emptyList()}, {this.superType, Collections.emptySet(), ImmutableList.of(this.superType)}, {null, Collections.singleton(this.interfaceType), ImmutableList.of(this.interfaceType)}, {this.superType, Collections.singleton(this.interfaceType), ImmutableList.of(this.superType, this.interfaceType)}};
    }

    @Test(dataProvider="parentTypesData")
    public void testParentTypes(TypeInfo superType, Set<TypeInfo> interfaces, List<TypeInfo> expected) throws Exception {
        Mockito.when((Object)this.type.parents()).thenReturn((Object)this.parents);
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)superType);
        Mockito.when(this.parents.immediateInterfaces()).thenReturn(interfaces);
        MatcherAssert.assertThat(MoreIterables.parentTypes(this.type), IterableMatchers.contains(expected));
    }

    @DataProvider
    Object[][] methodTypesData() {
        MockitoAnnotations.initMocks((Object)this);
        return new Object[][]{{this.type, Collections.emptyList(), ImmutableList.of(this.type)}, {this.type, ImmutableList.of(this.type), ImmutableList.of(this.type, this.type)}};
    }

    @Test(dataProvider="methodTypesData")
    public void testMethodTypes(TypeInfo returnType, List<TypeInfo> parameterTypes, List<TypeInfo> expected) throws Exception {
        Mockito.when((Object)this.method.getReturnType()).thenReturn((Object)returnType);
        Mockito.when(this.method.getParameterTypes()).thenReturn(parameterTypes);
        MatcherAssert.assertThat(MoreIterables.methodTypes(this.method), IterableMatchers.contains(expected));
    }
}

