/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;

public final class MoreIterables {
    private MoreIterables() {
    }

    public static <T> Collector<T, ArrayList<T>, List<T>> toUnmodifiableList() {
        return Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableList, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ArrayList<T>, List<T>> toUnmodifiableList(int initializeSize) {
        return Collector.of(() -> new ArrayList(initializeSize), ArrayList::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableList, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, HashSet<T>, Set<T>> toUnmodifiableSet() {
        return Collector.of(HashSet::new, HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, LinkedHashSet<T>, Set<T>> toUnmodifiableOrderedSet(int initializeSize) {
        return Collector.of(() -> new LinkedHashSet(initializeSize), HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, List<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (left, right) -> left.addAll((Iterable)right.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (left, right) -> left.addAll((Iterable)right.build()), ImmutableSet.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T, R> List<R> filterNullTransform(Collection<T> collection, Function<T, R> function) {
        return Optional.ofNullable(collection).map(values -> values.stream().filter(value -> value != null).map(function).collect(MoreIterables.toUnmodifiableList(collection.size()))).orElse(Collections.emptyList());
    }

    public static <T> boolean ensureNone(Iterable<T> iterable, Predicate<T> predicate) {
        return !MoreIterables.ensureAny(iterable, predicate);
    }

    public static <T> boolean ensureAny(Iterable<T> iterable, Predicate<T> predicate) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(predicate).findFirst().isPresent();
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> linkedHashSet(T ... entries) {
        return Sets.newLinkedHashSet(Arrays.asList(entries));
    }

    public static Iterable<TypeInfo> parentTypes(TypeInfo type) {
        return type.parents().superType() == null ? type.parents().immediateInterfaces() : Iterables.concat(Collections.singletonList(type.parents().superType()), type.parents().immediateInterfaces());
    }

    public static Iterable<TypeInfo> methodTypes(MethodInfo method) {
        return Iterables.concat(Collections.singletonList(method.getReturnType()), method.getParameterTypes());
    }

    public static String toString(Iterable<?> values, Collector<CharSequence, ?, String> joining) {
        return StreamSupport.stream(values.spliterator(), false).map(Object::toString).collect(joining);
    }

    public static String toString(Iterator<?> values, Collector<CharSequence, ?, String> joining) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(values, 16), false).map(Object::toString).collect(joining);
    }

    public static String toString(Collection<?> values, Collector<CharSequence, ?, String> joining) {
        return values.stream().map(Object::toString).collect(joining);
    }
}

