/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.collect.Queues;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ExtendedTypeIterable
implements Iterable<TypeInfo> {
    private final Set<TypeInfo> visited;
    private final Deque<TypeInfo> toVisit = Queues.newArrayDeque();

    public ExtendedTypeIterable(TypeInfo type) {
        this.visited = new HashSet<TypeInfo>();
        if (type != null) {
            this.toVisit.push(type);
        }
    }

    @Override
    public Iterator<TypeInfo> iterator() {
        return new Iterator<TypeInfo>(){

            @Override
            public boolean hasNext() {
                return !ExtendedTypeIterable.this.toVisit.isEmpty();
            }

            @Override
            public TypeInfo next() {
                if (ExtendedTypeIterable.this.toVisit.isEmpty()) {
                    throw new NoSuchElementException();
                }
                TypeInfo current = (TypeInfo)ExtendedTypeIterable.this.toVisit.remove();
                Set<TypeInfo> types = current.getUnitType() == UnitType.INTERFACE ? current.parents().immediateInterfaces() : (current.parents().superType() != null ? Collections.singletonList(current.parents().superType()) : Collections.emptyList());
                for (TypeInfo type : types) {
                    if (ExtendedTypeIterable.this.visited.contains(type)) continue;
                    ExtendedTypeIterable.this.toVisit.add(type);
                    ExtendedTypeIterable.this.visited.add(type);
                }
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove items from " + ExtendedTypeIterable.class.getSimpleName());
            }
        };
    }
}

