/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import com.google.common.collect.ImmutableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class CaseInsensitiveMapTest {
    @Test
    public void testPut() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        MatcherAssert.assertThat((Object)map.put("foo", Integer.valueOf(5)), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)map.put("FOO", Integer.valueOf(6)), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat(map, (Matcher)Matchers.aMapWithSize((int)1));
    }

    @Test
    public void testPutAll() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        map.putAll(ImmutableMap.of("foo", 1, "bar", 2));
        map.putAll(ImmutableMap.of("FOO", 3, "BAR", 4));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry((Object)"foo", (Object)3));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry((Object)"bar", (Object)4));
        MatcherAssert.assertThat(map, (Matcher)Matchers.aMapWithSize((int)2));
    }

    @Test
    public void testGet() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        MatcherAssert.assertThat(map.get("foo"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat(map.get("FOO"), (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void testContainsKey() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)map.containsKey("foo"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)map.containsKey("FOO"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemove() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        map.put("bar", Integer.valueOf(7));
        MatcherAssert.assertThat(map.remove("foo"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat(map.remove("BAR"), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void testClear() {
        CaseInsensitiveMap<Integer> map = new CaseInsensitiveMap<Integer>();
        map.put("foo", Integer.valueOf(5));
        map.put("bar", Integer.valueOf(7));
        map.clear();
        MatcherAssert.assertThat(map, (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)map.containsKey("BAR"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)map.containsKey("FOO"), (Matcher)Matchers.is((Object)false));
    }
}

