/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.services.MyInterner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CaseInsensitiveMap<V>
extends HashMap<String, V> {
    public static <V> Builder<V> builder() {
        return new Builder();
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? (V)super.get(((String)key).toLowerCase()) : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && super.containsKey(((String)key).toLowerCase());
    }

    @Override
    public V put(String key, V value) {
        return super.put(MyInterner.intern(key.toLowerCase()), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? (V)super.remove(MyInterner.intern(((String)key).toLowerCase())) : null;
    }

    public static class Builder<V> {
        private final CaseInsensitiveMap<V> map = new CaseInsensitiveMap();

        private Builder() {
        }

        public Builder<V> put(String key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<V> putAll(Map<String, V> other) {
            this.map.putAll(other);
            return this;
        }

        public Map<String, V> build() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

