/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class MapPutAllValidator
implements BuiltInMethodValidator {
    private static final MapPutAllValidator INSTANCE = new MapPutAllValidator();

    private MapPutAllValidator() {
    }

    public static boolean isInvalidMapInitializationFromList(TypeInfo referencingType, TypeInfo mapType, TypeInfo initType) {
        if (CollectionTypeInfoUtil.getValueType(mapType).getBasicType() == BasicType.SOBJECT) {
            if (TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(mapType), TypeInfos.SOBJECT) && SObjectTypeInfoUtil.isSObjectList(initType) && Distance.get().canAssign(referencingType, CollectionTypeInfoUtil.getKeyType(mapType), (TypeInfo)TypeInfos.ID)) {
                return false;
            }
            if (SObjectTypeInfoUtil.isConcreteSObjectList(initType) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getValueType(mapType), CollectionTypeInfoUtil.getElementType(initType)) && Distance.get().canAssign(referencingType, CollectionTypeInfoUtil.getKeyType(mapType), (TypeInfo)TypeInfos.ID)) {
                return false;
            }
        }
        return true;
    }

    public static BuiltInMethodValidator get() {
        return INSTANCE;
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope, MethodCallExpression expression) {
        TypeInfo mapType = expression.getMethod().getDefiningType();
        TypeInfo initType = expression.getInputParameters().get(0).getType();
        if (MapPutAllValidator.isInvalidMapInitializationFromList(expression.getDefiningType(), mapType, initType)) {
            scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("invalid.map.putAll", initType, mapType));
        }
    }
}

