/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectListPeelInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;

public class AddErrorValidator
implements BuiltInMethodValidator {
    private static final BuiltInMethodValidator INSTANCE = new AddErrorValidator();

    private AddErrorValidator() {
    }

    public static BuiltInMethodValidator get() {
        return INSTANCE;
    }

    @Override
    public void validate(SymbolResolver symbols, final ValidationScope scope, final MethodCallExpression expression) {
        Iterables.getLast(expression.getReferenceExpression().getVariables()).accept(new VariableVisitor.Default<Void>(){

            @Override
            public Void _default(Variable info, VariableVisitor.Context context) {
                scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.invalid.add.error.not.sobject.field"));
                return null;
            }

            @Override
            public Void visit(SObjectFieldInfo info, VariableVisitor.Context context) {
                if (ExpressionUtil.isSoqlExpression(expression.getReferenceExpression().getDottedExpression().getExpression()) || info.getCategory() != SObjectFieldInfo.Category.REGULAR || !info.isColumnInfo()) {
                    scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("method.invalid.add.error.not.sobject.scalar.field"));
                }
                return null;
            }

            @Override
            public Void visit(SObjectListPeelInfo info, VariableVisitor.Context context) {
                info.getVariable().accept(this, context);
                return null;
            }
        }, new VariableVisitor.Context());
    }
}

