/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.common.initializer.Initializer;
import apex.jorje.semantic.common.initializer.Initializers;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodTableFactory;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public final class ObjectMethods {
    public static final Supplier<MethodInfo> HASH_CODE_METHOD = Suppliers.memoize(() -> ObjectMethods.getInstanceBuilder().setReturnType(TypeInfos.INTEGER).setName("hashCode").build());
    public static final Supplier<MethodInfo> EQUALS_METHOD = Suppliers.memoize(() -> ObjectMethods.getInstanceBuilder().setReturnType(TypeInfos.BOOLEAN).setName("equals").setNamedParameterTypes(TypeInfos.OBJECT).build());
    public static final Initializer<MethodTable, TypeInfo> METHODS = Initializers.memoize(type -> MethodTableFactory.create(ObjectMethods.getInstanceBuilder().setReturnType(TypeInfos.STRING).setName("toString").build(), HASH_CODE_METHOD.get(), EQUALS_METHOD.get(), ObjectMethods.getInstanceBuilder().setReturnType(TypeInfos.VOID).setConstructor().build()));

    private ObjectMethods() {
    }

    public static AsmMethod constructor(TypeInfo type, TypeInfo ... params) {
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(type).setFunction("<init>").setSignature((TypeInfo)TypeInfos.VOID, params).build();
    }

    public static AsmMethod equalsBridge(TypeInfo classType, String function) {
        assert ("equals".equalsIgnoreCase(function));
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(classType).setFunction(function).setSignature((TypeInfo)TypeInfos.BOOLEAN, (TypeInfo)TypeInfos.OBJECT).build();
    }

    public static AsmMethod javaEquals() {
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(TypeInfos.OBJECT).setFunction("equals").setSignature(InternalTypeInfos.PRIMITIVE_BOOLEAN, (TypeInfo)TypeInfos.OBJECT).build();
    }

    public static AsmMethod hashCodeBridge(TypeInfo classType, String function) {
        assert ("hashCode".equalsIgnoreCase(function));
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(classType).setFunction(function).setSignature((TypeInfo)TypeInfos.INTEGER, new TypeInfo[0]).build();
    }

    public static AsmMethod javaHashCode() {
        return AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(TypeInfos.OBJECT).setFunction("hashCode").setSignature(InternalTypeInfos.PRIMITIVE_INTEGER, new TypeInfo[0]).build();
    }

    private static StandardMethodInfoBuilder getInstanceBuilder() {
        return StandardMethodInfo.builder().setGenerated(Generated.BUILT_IN).setDefiningType(TypeInfos.OBJECT).setModifiers(ModifierGroups.GLOBAL_VIRTUAL);
    }
}

