/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public class AsmMethod {
    public static final String STATIC_INIT = "<clinit>";
    public static final String INIT = "<init>";
    public final int opcode;
    public final String definingType;
    public final String function;
    public final Signature signature;
    public final boolean definerInterface;

    private AsmMethod(Builder builder) {
        this.opcode = builder.opcode;
        this.definingType = builder.definingType;
        this.function = builder.function;
        this.signature = builder.signature;
        this.definerInterface = builder.definerInterface;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int opcode;
        private String definingType;
        private String function;
        private Signature signature;
        private boolean definerInterface = false;

        private Builder() {
        }

        public Builder setDefiningTypeAsBytecodeMethodName(TypeInfo definingType) {
            this.definingType = definingType.getBytecodeMethodName();
            this.updateInvocationIfInterface(definingType);
            return this;
        }

        public Builder setDefiningTypeAsBytecodeName(TypeInfo definingType) {
            this.definingType = definingType.getBytecodeName();
            this.updateInvocationIfInterface(definingType);
            return this;
        }

        public Builder setDefiningTypeName(String definingType) {
            this.definingType = definingType;
            return this;
        }

        private void updateInvocationIfInterface(TypeInfo definingType) {
            if (definingType.getUnitType() == UnitType.INTERFACE && definingType.getBasicType() != BasicType.JAVA) {
                this.invokeInterface();
            }
        }

        public Builder setFunction(String function) {
            this.function = function;
            return this;
        }

        public Builder setSignature(TypeInfo returnType, TypeInfo paramTypes) {
            return this.setSignature(returnType, ImmutableList.of(paramTypes));
        }

        public Builder setSignature(TypeInfo returnType, TypeInfo ... paramTypes) {
            return this.setSignature(returnType, Arrays.asList(paramTypes));
        }

        public Builder setSignature(TypeInfo returnType, List<TypeInfo> paramTypes) {
            this.signature = SignatureFactory.create("", returnType, paramTypes);
            return this;
        }

        public Builder setSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder setOpcode(int opcode) {
            this.opcode = opcode;
            return this;
        }

        public Builder invoke(InvocationType invocationType) {
            Builder builder = AsmMethod.builder();
            switch (invocationType) {
                case STATIC: {
                    return builder.invokeStatic();
                }
                case VIRTUAL: {
                    return builder.invokeVirtual();
                }
                case SPECIAL: {
                    return builder.invokeSpecial();
                }
            }
            throw new UnsupportedOperationException(Builder.class.getSimpleName() + " doesn't support these?");
        }

        public Builder invokeVirtual() {
            return this.setOpcode(182);
        }

        public Builder invokeStatic() {
            return this.setOpcode(184);
        }

        public Builder invokeSpecial() {
            return this.setOpcode(183);
        }

        public Builder invokeInterface() {
            this.definerInterface = true;
            return this.setOpcode(185);
        }

        public AsmMethod build() {
            assert (this.opcode != 0);
            assert (this.definingType != null);
            assert (this.function != null);
            assert (this.signature != null);
            return new AsmMethod(this);
        }
    }
}

