/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.semantic.tester.matchers.IsExternalDependency;
import apex.jorje.semantic.tester.matchers.IsTypeWithApexName;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReferenceVisitorTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] referringUserTypeData() {
        return new Object[][]{{"public class Foo{ }", "public class Bar{ Foo f; }", "Bar", "Foo"}, {"public class Foo{ }", "public class Bar{ void method(){ Foo f;} }", "Bar", "Foo"}, {"public class Foo{ }", "public class Bar{ void doSomethingToFoo(Foo f){} }", "Bar", "Foo"}, {"public class Foo{ }", "public class Bar{ public Foo getNewFoo(){ return new Foo();} }", "Bar", "Foo"}, {"public class FooException extends Exception{ }", "public class Bar{ public void doWrong(){ try{}catch(FooException f){} } }", "Bar", "FooException"}, {"public class Foo { public static void doNothing(){} }", "public class Bar{ public void callDoNothing(){ Foo.doNothing(); } }", "Bar", "Foo"}, {"public class Foo{ }", "public class Bar{ void callMethod(){ new Foo();} }", "Bar", "Foo"}, {"public class Foo{ public Integer num; public Foo(){ num = 0; } }", "public class Bar{ void forMethod(){ Integer i =10; for(Foo f=new Foo(); i > f.num; i--){} } }", "Bar", "Foo"}, {"public class Foo{ public Foo(){ } }", "public class Bar{ List<Object> fooList; public Bar(){ for(Foo f : new List<Foo>()){} } }", "Bar", "Foo"}};
    }

    @Test(dataProvider="referringUserTypeData")
    public void testUserTypeReferences(String referredCode, String referringCode, String referringTypeName, String referredTypeName) {
        ApexCompiler compiler = this.buildCompilerForSources(referredCode, referringCode);
        Map<TypeInfo, Collection<ExternalDependency>> map = Iterables.getOnlyElement(compiler.getReferences()).asMap();
        MatcherAssert.assertThat(map, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry(IsTypeWithApexName.hasApexName(referringTypeName), (Matcher)IsCollectionContaining.hasItem(IsExternalDependency.dependencyWithType(referredTypeName))));
    }

    @DataProvider
    Object[][] referringSObjectTypeData() {
        return new Object[][]{{"public class Foo { Account a; }", "Foo", "Account"}, {"public class Foo { List<Account> aList; }", "Foo", "Account"}, {"public class Foo { void method(){ Account a;} }", "Foo", "Account"}, {"public class Foo { Account getAccount(){ return null;} }", "Foo", "Account"}, {"public class Foo { void processAccount(Account a){ } }", "Foo", "Account"}, {"trigger Bar on Account(before insert){  }", "Bar", "Account"}, {"trigger Bar on Account(before insert){ Contact c; }", "Bar", "Contact"}};
    }

    @Test(dataProvider="referringSObjectTypeData")
    public void testObjectReferences(String source, String referringTypeName, String referredTypeName) {
        ApexCompiler compiler = this.buildCompilerForSources(source);
        Map<TypeInfo, Collection<ExternalDependency>> map = Iterables.getOnlyElement(compiler.getReferences()).asMap();
        MatcherAssert.assertThat(map, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry(IsTypeWithApexName.hasApexName(referringTypeName), (Matcher)IsCollectionContaining.hasItem(IsExternalDependency.dependencyWithType(referredTypeName))));
    }

    @DataProvider
    Object[][] referringFieldInfoData() {
        return new Object[][]{{"public class Foo { Account a; void method(){ String str = a.name;} }", "Foo", "Name"}, {"public class Foo { Account a; void method(){ String str = 'a'; a.name = str;} }", "Foo", "Name"}, {"public class Foo { Account a; String str = a.name; }", "Foo", "Name"}, {"trigger Bar on Account(before insert){ Account a; System.debug(a.name); }", "Bar", "Name"}, {"trigger Bar on Account(before insert){ Account a = new Account(name='foo'); }", "Bar", "Name"}};
    }

    @Test(dataProvider="referringFieldInfoData")
    public void testFieldInfoReferences(String source, String referringTypeName, String referredVariableName) {
        ApexCompiler compiler = this.buildCompilerForSources(source);
        Map<TypeInfo, Collection<ExternalDependency>> map = Iterables.getOnlyElement(compiler.getReferences()).asMap();
        MatcherAssert.assertThat(map, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry(IsTypeWithApexName.hasApexName(referringTypeName), (Matcher)IsCollectionContaining.hasItem(IsExternalDependency.dependencyWithFieldName(referredVariableName))));
    }

    @DataProvider
    Object[][] referringUserTypeFieldInfoData() {
        return new Object[][]{{"public class Foo { public static String fooString; }", "public class Bar { public static String barString = Foo.fooString;   }", "Bar", "Foo", "fooString"}, {"public class Foo { public String fooString; }", "public class Bar { Foo f; public String barString = f.fooString;   }", "Bar", "Foo", "fooString"}};
    }

    @Test(dataProvider="referringUserTypeFieldInfoData")
    public void testUserTypeFieldInfoReferences(String source, String referredSource, String referringTypeName, String referredTypeName, String referredVariableName) {
        ApexCompiler compiler = this.buildCompilerForSources(source, referredSource);
        Map<TypeInfo, Collection<ExternalDependency>> map = Iterables.getOnlyElement(compiler.getReferences()).asMap();
        MatcherAssert.assertThat(map, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry(IsTypeWithApexName.hasApexName(referringTypeName), (Matcher)IsCollectionContaining.hasItem(IsExternalDependency.userTypeDependencyWithFieldName(referredTypeName, referredVariableName))));
    }

    @DataProvider
    Object[][] referringDmlData() {
        return new Object[][]{{"public class Foo { Account a; void method(){ insert a; } }", "Foo", "Account", DmlOperation.INSERT}, {"public class Foo { Account a; void method(){ update a; } }", "Foo", "Account", DmlOperation.UPDATE}, {"public class Foo { Account a; void method(){ delete a; } }", "Foo", "Account", DmlOperation.DELETE}, {"public class Foo { Account a; void method(){ undelete a; } }", "Foo", "Account", DmlOperation.UNDELETE}, {"public class Foo { Account a; { Database.insert(a, false); } }", "Foo", "Account", DmlOperation.INSERT}, {"public class Foo { Account a; { Database.upsert(a, false); } }", "Foo", "Account", DmlOperation.UPSERT}};
    }

    @Test(dataProvider="referringDmlData")
    public void testDmlOperationReferences(String source, String referringTypeName, String referredTypeName, DmlOperation dmlOperation) {
        ApexCompiler compiler = this.buildCompilerForSources(source);
        Map<TypeInfo, Collection<ExternalDependency>> map = Iterables.getOnlyElement(compiler.getReferences()).asMap();
        MatcherAssert.assertThat(map, (Matcher)IsMapWithSize.aMapWithSize((int)1));
        MatcherAssert.assertThat(map, (Matcher)Matchers.hasEntry(IsTypeWithApexName.hasApexName(referringTypeName), (Matcher)IsCollectionContaining.hasItem(IsExternalDependency.dependencyWith(referredTypeName, dmlOperation))));
    }

    @Test
    public void noSelfReference() {
        ApexCompiler compiler = this.buildCompilerForSources("public enum Foo { a, b }");
        MatcherAssert.assertThat(compiler.getReferences(), (Matcher)Matchers.emptyIterable());
    }

    private ApexCompiler buildCompilerForSources(String ... sources) {
        List<SourceFile> sourceFiles = this.tester.createSources(Arrays.asList(sources));
        ApexCompiler compiler = this.tester.buildCompiler(ParserWrapper.Type.NAMED, sourceFiles);
        compiler.compileThrowErrors();
        return compiler;
    }
}

