/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewNameValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.ast.visitor.reference.ReferencedTypeVisitor;
import apex.jorje.semantic.ast.visitor.reference.SchemaSObjectFieldReferenceVisitor;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReferenceVisitor
extends AstVisitor<SymbolScope> {
    private static final TypeInfoVisitor<List<TypeInfo>> GET_EXTERNAL_TYPE_VISITOR = new ReferencedTypeVisitor();
    private final ListMultimap<TypeInfo, ExternalDependency> referenceDependencyMap;
    private final TypeInfo type;
    private final Map<TypeInfo, CodeUnit> typeInfoToCodeUnit;

    public ReferenceVisitor(TypeInfo type, Map<TypeInfo, CodeUnit> typeInfoToCodeUnit) {
        this.type = type;
        this.typeInfoToCodeUnit = typeInfoToCodeUnit;
        this.referenceDependencyMap = ArrayListMultimap.create();
    }

    @Override
    public boolean defaultVisit() {
        return true;
    }

    private void variableVisit(final ReferenceType referenceType, Variable variable) {
        variable.accept(new VariableVisitor.Default<Void>(){

            @Override
            public Void _default(Variable info, VariableVisitor.Context context) {
                return null;
            }

            @Override
            public Void visit(StandardFieldInfo info, VariableVisitor.Context context) {
                this.checkAndAddReferenceRelationship(info);
                return null;
            }

            @Override
            public Void visit(SObjectFieldInfo info, VariableVisitor.Context context) {
                this.checkAndAddReferenceRelationship(info);
                return null;
            }

            @Override
            public Void visit(DynamicFieldInfo info, VariableVisitor.Context context) {
                this.checkAndAddReferenceRelationship(info);
                return null;
            }

            private void checkAndAddReferenceRelationship(Variable variable) {
                ReferenceVisitor.this.checkAndAddReferenceRelationship(ReferenceVisitor.this.type, variable.getDefiningType(), variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferenceType(referenceType).build());
            }
        }, null);
    }

    public ListMultimap<TypeInfo, ExternalDependency> getReferenceDependencyMap() {
        return this.referenceDependencyMap;
    }

    private boolean validateDatabaseMethods(MethodInfo methodInfo, List<Expression> inputParameters, Loc loc) {
        if (TypeInfoEquivalence.isEquivalent(methodInfo.getDefiningType(), InternalTypeInfos.DATABASE) && methodInfo.getInvocationType() == InvocationType.STATIC) {
            ReferenceInfo referenceInfo;
            if (inputParameters.isEmpty()) {
                return false;
            }
            TypeInfo paramType = TypeInfoUtil.peelType(inputParameters.get(0).getType());
            switch (methodInfo.getCanonicalName()) {
                case "insert": {
                    referenceInfo = ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.INSERT).build();
                    break;
                }
                case "merge": {
                    referenceInfo = ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.MERGE).build();
                    break;
                }
                case "update": {
                    referenceInfo = ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UPDATE).build();
                    break;
                }
                case "delete": {
                    referenceInfo = ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.DELETE).build();
                    break;
                }
                case "upsert": {
                    referenceInfo = inputParameters.size() > 1 ? this.getReferenceInfoForSchemaSObjectFieldUpsert(inputParameters) : ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UPSERT).build();
                    break;
                }
                case "undelete": {
                    referenceInfo = ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UNDELETE).build();
                    break;
                }
                default: {
                    referenceInfo = null;
                }
            }
            if (referenceInfo != null) {
                this.checkAndAddReferenceRelationship(this.type, paramType, loc, referenceInfo);
                return true;
            }
        }
        return false;
    }

    private ReferenceInfo getReferenceInfoForSchemaSObjectFieldUpsert(List<Expression> inputParameters) {
        Expression fieldParameter = inputParameters.get(1);
        ReferenceInfo evaluatedReferenceInfo = ValueScope.evaluate(fieldParameter, new AstVisitor<ValueScope<ReferenceInfo>>(){

            @Override
            protected boolean defaultVisit() {
                return false;
            }

            @Override
            public boolean visit(VariableExpression node, ValueScope<ReferenceInfo> scope) {
                node.getVariable().accept(new SchemaSObjectFieldReferenceVisitor(scope), null);
                return true;
            }
        }, null);
        ReferenceInfo referenceInfo = evaluatedReferenceInfo != null ? evaluatedReferenceInfo : ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UPSERT).build();
        return referenceInfo;
    }

    private boolean isMyCodeUnit(TypeInfo referringType, TypeInfo referredType) {
        return TypeInfoEquivalence.isEquivalent(TypeInfoUtil.getTopLevel(referredType), referringType);
    }

    private void checkAndAddReferenceRelationship(TypeInfo referringType, TypeInfo referredType, Loc loc) {
        this.checkAndAddReferenceRelationship(referringType, referredType, loc, ReferenceInfo.empty());
    }

    private void checkAndAddReferenceRelationship(TypeInfo referringType, TypeInfo referredType, Loc loc, ReferenceInfo referenceInfo) {
        List<TypeInfo> typeInfos = this.findApexDependencies(referringType, ExternalDependency.create(referredType, loc, referenceInfo));
        CodeUnit currentCodeUnit = this.typeInfoToCodeUnit.get(this.type);
        for (TypeInfo typeInfo : typeInfos) {
            if (this.isMyCodeUnit(referringType, typeInfo)) continue;
            this.referenceDependencyMap.put(referringType, ExternalDependency.create(typeInfo, loc, referenceInfo));
            this.propagateInvalidDependencyErrors(loc, currentCodeUnit, typeInfo);
        }
    }

    private void propagateInvalidDependencyErrors(Loc loc, CodeUnit currentCodeUnit, TypeInfo typeInfo) {
        CompilationException exception;
        CodeUnit otherCodeUnit = this.typeInfoToCodeUnit.get(typeInfo);
        if (otherCodeUnit != null && !otherCodeUnit.getErrors().isEmpty() && (exception = (CompilationException)Iterables.getFirst(otherCodeUnit.getErrors().get(), null)) != null) {
            String errorMessage = currentCodeUnit.getType().getUnitType() == UnitType.ANONYMOUS ? exception.getError() : I18nSupport.getLabel("dependent.class.invalid", typeInfo.getApexName(), exception.getError());
            currentCodeUnit.getErrors().get().add(new SemanticException(loc, errorMessage));
        }
    }

    private List<TypeInfo> findApexDependencies(TypeInfo referringType, ExternalDependency dependency) {
        if (!this.isMyCodeUnit(referringType, dependency.getTypeInfo()) && !this.referenceDependencyMap.containsEntry(referringType, dependency)) {
            List<TypeInfo> referredTypes = dependency.getTypeInfo().accept(GET_EXTERNAL_TYPE_VISITOR);
            List<TypeInfo> referringTypes = referringType.accept(GET_EXTERNAL_TYPE_VISITOR);
            if (!referringTypes.isEmpty()) {
                return referredTypes;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        for (TypeInfo type : MoreIterables.parentTypes(node.getDefiningType())) {
            this.checkAndAddReferenceRelationship(node.getDefiningType(), type, node.getLoc());
        }
        return true;
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        TypeInfo triggerTypeInfo = node.getDefiningType();
        TypeInfo sobjectTypeInfo = node.getTargetType();
        this.checkAndAddReferenceRelationship(triggerTypeInfo, sobjectTypeInfo, node.getLoc());
        return true;
    }

    @Override
    public boolean visit(ReferenceExpression node, SymbolScope scope) {
        for (Variable fieldInfo : node.getVariables()) {
            this.variableVisit(node.getReferenceType(), fieldInfo);
        }
        return true;
    }

    @Override
    public boolean visit(MethodCallExpression node, SymbolScope scope) {
        MethodInfo methodInfo = node.getMethod();
        TypeInfo definingType = methodInfo.getDefiningType();
        this.validateDatabaseMethods(methodInfo, node.getInputParameters(), node.getLoc());
        if (methodInfo.getInvocationType() == InvocationType.STATIC) {
            this.checkAndAddReferenceRelationship(this.type, definingType, node.getLoc());
        }
        for (TypeInfo type : MoreIterables.methodTypes(methodInfo)) {
            this.checkAndAddReferenceRelationship(definingType, type, node.getLoc());
        }
        return true;
    }

    @Override
    public boolean visit(NewObjectExpression node, SymbolScope scope) {
        TypeInfo varType = node.getType();
        this.checkAndAddReferenceRelationship(this.type, varType, node.getLoc());
        return true;
    }

    @Override
    public boolean visit(NewNameValueObjectExpression node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getType(), node.getLoc());
        for (NewNameValueObjectExpression.NameValueParameter parameter : node.getParameters()) {
            SObjectFieldInfo info = parameter.getFieldInfo();
            if (info == null) continue;
            this.checkAndAddReferenceRelationship(this.type, info.getDefiningType(), node.getLoc(), ReferenceInfo.builder().setVariable(info).build());
        }
        return true;
    }

    @Override
    public boolean visit(VariableExpression node, SymbolScope scope) {
        this.variableVisit(node.getReferenceType(), node.getVariable());
        return true;
    }

    @Override
    public boolean visit(DmlDeleteStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.DELETE).build());
        return true;
    }

    @Override
    public boolean visit(DmlInsertStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.INSERT).build());
        return true;
    }

    @Override
    public boolean visit(DmlMergeStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.MERGE).build());
        return true;
    }

    @Override
    public boolean visit(DmlUndeleteStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UNDELETE).build());
        return true;
    }

    @Override
    public boolean visit(DmlUpdateStatement node, SymbolScope scope) {
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UPDATE).build());
        return true;
    }

    @Override
    public boolean visit(DmlUpsertStatement node, SymbolScope scope) {
        TypeInfo entityType = node.getExpression().getType();
        Variable fieldInfo = node.getFieldIdentifier().isPresent() ? (Variable)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)((SObjectFieldInfo.Builder)SObjectFieldInfo.builder().setDefiningType(entityType)).setType(InternalTypeInfos.SCHEMA_SOBJECT_FIELD)).setModifiers(ModifierGroups.STATEMENT_EXECUTED)).setName(node.getFieldIdentifier().get().field.value)).build() : null;
        this.checkAndAddReferenceRelationship(this.type, node.getExpression().getType(), node.getLoc(), ReferenceInfo.builder().setVariable(fieldInfo).setReferenceType(ReferenceType.LOAD).setDmlOperation(DmlOperation.UPSERT).build());
        return true;
    }

    @Override
    public boolean visit(VariableDeclaration node, SymbolScope scope) {
        TypeInfo definingType = node.getLocalInfo().getDefiningType();
        TypeInfo varType = node.getLocalInfo().getType();
        this.checkAndAddReferenceRelationship(definingType, varType, node.getLoc());
        return true;
    }

    @Override
    public boolean visit(CatchBlockStatement node, SymbolScope scope) {
        TypeInfo definingType = node.getVariable().getDefiningType();
        TypeInfo varType = node.getVariable().getType();
        this.checkAndAddReferenceRelationship(definingType, varType, node.getLoc());
        return true;
    }

    @Override
    public boolean visit(Field node, SymbolScope scope) {
        TypeInfo definingType = node.getFieldInfo().getDefiningType();
        TypeInfo fieldType = node.getFieldInfo().getType();
        this.checkAndAddReferenceRelationship(definingType, fieldType, node.getLoc());
        return true;
    }

    @Override
    public boolean visit(Method node, SymbolScope scope) {
        TypeInfo definingType = node.getMethodInfo().getDefiningType();
        for (TypeInfo type : MoreIterables.methodTypes(node.getMethodInfo())) {
            this.checkAndAddReferenceRelationship(definingType, type, node.getLoc());
        }
        return true;
    }
}

