/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.member.variable.Variable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class ReferenceInfo {
    private static final ReferenceInfo EMPTY = ReferenceInfo.builder().build();
    private final Variable variable;
    private final DmlOperation dmlOperation;
    private final ReferenceType referenceType;

    private ReferenceInfo(Builder builder) {
        this.variable = builder.variable;
        this.referenceType = builder.referenceType;
        this.dmlOperation = builder.dmlOperation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReferenceInfo empty() {
        return EMPTY;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.variable, this.dmlOperation, this.referenceType});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceInfo that = (ReferenceInfo)o;
        return Objects.equal(this.variable, that.variable) && Objects.equal((Object)this.dmlOperation, (Object)that.dmlOperation) && Objects.equal((Object)this.referenceType, (Object)that.referenceType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("variable", this.variable).add("dmlOperation", (Object)this.dmlOperation).add("referenceType", (Object)this.referenceType).toString();
    }

    public DmlOperation getDmlOperation() {
        return this.dmlOperation;
    }

    public static class Builder {
        private Variable variable = null;
        private DmlOperation dmlOperation = null;
        private ReferenceType referenceType = null;

        private Builder() {
        }

        public ReferenceInfo build() {
            return new ReferenceInfo(this);
        }

        public Builder setReferenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public Builder setDmlOperation(DmlOperation dmlOperation) {
            this.dmlOperation = dmlOperation;
            return this;
        }

        public Builder setVariable(Variable variable) {
            this.variable = variable;
            return this;
        }
    }
}

