/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.Signature;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import java.util.HashMap;
import java.util.Map;

public class PostTypeResolveVisitorUtil {
    static void validateOneAnnotationPerType(Compilation node, SymbolScope scope) {
        HashMap<StandardAnnotationTypeInfo, Integer> map = new HashMap<StandardAnnotationTypeInfo, Integer>();
        map.put(AnnotationTypeInfos.HTTP_DELETE, 0);
        map.put(AnnotationTypeInfos.HTTP_GET, 0);
        map.put(AnnotationTypeInfos.HTTP_PATCH, 0);
        map.put(AnnotationTypeInfos.HTTP_POST, 0);
        map.put(AnnotationTypeInfos.HTTP_PUT, 0);
        map.put(AnnotationTypeInfos.INVOCABLE_METHOD, 0);
        HashMultimap<String, Integer> remoteActions = HashMultimap.create();
        for (MethodInfo methodInfo : node.getDefiningType().methods().all()) {
            for (Map.Entry entry : map.entrySet()) {
                if (!methodInfo.getModifiers().has((ModifierOrAnnotationTypeInfo)entry.getKey())) continue;
                map.put((StandardAnnotationTypeInfo)entry.getKey(), (Integer)entry.getValue() + 1);
            }
            if (!methodInfo.getModifiers().has(AnnotationTypeInfos.REMOTE_ACTION)) continue;
            if (remoteActions.containsEntry(methodInfo.getName(), methodInfo.getParameters().size())) {
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.remote.action.methods"));
                continue;
            }
            remoteActions.put(methodInfo.getName(), methodInfo.getParameters().size());
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("invalid.multiple.methods.with.modifier", entry.getKey()));
        }
    }

    static void validateTestSetupClass(AnnotationContext context, UserClass node) {
        boolean classHasSeeAllData;
        boolean methodHasTestSetup = false;
        boolean methodHasSeeAllData = false;
        for (MethodInfo method : Collections2.filter(node.getDefiningType().methods().all(), Predicates.not(MethodTable.CONSTRUCTORS_ONLY))) {
            methodHasSeeAllData |= PostTypeResolveVisitorUtil.hasSeeAllData(method.getModifiers());
            if (method.getModifiers().some(AnnotationTypeInfos.TEST_SETUP)) {
                methodHasTestSetup = true;
            }
            if (!methodHasSeeAllData || !methodHasTestSetup) continue;
            context.addNodeError(I18nSupport.getLabel("test.setup.cannot.have.see.all.data"));
            return;
        }
        boolean bl = classHasSeeAllData = PostTypeResolveVisitorUtil.hasSeeAllData(node.getDefiningType().getModifiers()) || node.getDefiningType().getEnclosingType() != null && PostTypeResolveVisitorUtil.hasSeeAllData(node.getDefiningType().getEnclosingType().getModifiers());
        if (classHasSeeAllData && methodHasTestSetup) {
            context.addNodeError(I18nSupport.getLabel("test.setup.cannot.have.defining.type.see.all.data"));
        }
    }

    static boolean hasSeeAllData(ModifierGroup modifiers) {
        AnnotationParameter isTestParam;
        if (modifiers.has(AnnotationTypeInfos.IS_TEST) && (isTestParam = modifiers.get(AnnotationTypeInfos.IS_TEST).getParameter("seeAllData")).getValue() != null) {
            return isTestParam.getBooleanValue();
        }
        return false;
    }

    static void validateNoStaticMethodClashes(UserClass node, SymbolScope scope) {
        Version version = VersionUtil.get(node);
        block0: for (MethodInfo method : node.getDefiningType().methods().instance()) {
            for (TypeInfo current : new SuperTypeIterable(node.getDefiningType())) {
                Result<MethodInfo> result = current.methods().getApproximate(version, method.getSignature(), MethodLookupMode.STATICS);
                if (scope.getErrors().addIfError(node, result)) continue block0;
                if (!result.isPresent() || !Visibility.isMemberVisibleNoTestCheck(node.getDefiningType(), result.get().getDefiningType(), result.get().getModifiers())) continue;
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("cannot.override.static.method", result.get().getSignature(), method.getSignature()));
                continue block0;
            }
        }
    }

    static void validateInterfaceImplementations(UserClass node, SymbolScope scope) {
        Version version = VersionUtil.get(node);
        boolean isAbstract = node.getDefiningType().getModifiers().has(ModifierTypeInfos.ABSTRACT);
        for (TypeInfo _interface : node.getDefiningType().parents().allInterfaces()) {
            boolean isVisible = Visibility.isTypeVisible(scope.getSymbols().getAccessEvaluator(), node.getDefiningType(), _interface, false);
            if (!isVisible) continue;
            for (MethodInfo methodInterface : _interface.methods().instance()) {
                Result<MethodInfo> result = PostTypeResolveVisitorUtil.getApproximate(node.getDefiningType(), version, methodInterface.getSignature());
                if (result.hasError() || result.absent()) {
                    if (isAbstract) continue;
                    scope.getErrors().addIfError((AstNode)node, result, I18nSupplier.create("interface.implementation.missing.method", node.getDefiningType(), methodInterface));
                    continue;
                }
                MethodInfo methodImpl = result.get();
                if (!Distance.get().canAssign(node.getDefiningType(), methodImpl.getReturnType(), methodInterface.getReturnType())) {
                    if (isAbstract) continue;
                    scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("interface.implementation.missing.method", node.getDefiningType(), methodInterface));
                    continue;
                }
                if (!isAbstract) {
                    if (methodImpl.getModifiers().none(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC)) {
                        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("interface.implementation.method.not.visible", node.getDefiningType(), methodInterface, _interface));
                    }
                    if (methodImpl.getModifiers().has(AnnotationTypeInfos.DEPRECATED)) {
                        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("interface.implementation.method.deprecated", methodInterface));
                    }
                }
                methodImpl.setMethodInterface(methodInterface);
            }
        }
    }

    private static Result<MethodInfo> getApproximate(TypeInfo type, Version version, Signature signature) {
        Result<MethodInfo> result = type.virtualMethods().getApproximate(version, signature, MethodLookupMode.INSTANCE);
        return result.hasResult() ? result : type.methods().getApproximate(version, signature, MethodLookupMode.STATICS);
    }
}

