/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.PackageVersionExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrinterUtil;
import java.util.List;

@SfdcCalled
public class PackageValidatorAdditionalCompilationVerificationVisitor
extends AstVisitor<AdditionalPassScope> {
    private final String namespaceNameLower;
    private final boolean doUnmanagedPackageChecks;

    public PackageValidatorAdditionalCompilationVerificationVisitor(Namespace namespace, boolean isManaged) {
        this.namespaceNameLower = namespace.getNameLower();
        this.doUnmanagedPackageChecks = !isManaged && !Namespace.isEmptyOrNull(namespace);
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            node.getParentTypeRef().ifPresent(value -> this.checkName(scope, (TypeRef)value));
        }
    }

    @Override
    public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getTargetName());
        }
    }

    @Override
    public void visitEnd(MethodCallExpression node, AdditionalPassScope scope) {
        this.checkDescribeDataCategoryReferences(scope, node.getReferenceExpression());
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getReferenceExpression());
            this.checkName(scope, node.getNameUsed());
        }
    }

    @Override
    public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getTypeRef());
        }
    }

    @Override
    public void visitEnd(PackageVersionExpression node, AdditionalPassScope scope) {
        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("package.version.forbidden"));
    }

    @Override
    public void visitEnd(FieldDeclaration node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getTypeNameUsed());
        }
    }

    @Override
    public void visitEnd(VariableDeclaration node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getTypeNameUsed());
        }
    }

    @Override
    public void visitEnd(Parameter node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getTypeRef());
        }
    }

    @Override
    public void visitEnd(Method node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName(scope, node.getReturnTypeRef());
        }
    }

    private void checkName(final AdditionalPassScope scope, TypeRef typeRef) {
        if (typeRef == TypeReferences.GENERATED_TYPE_REF) {
            return;
        }
        typeRef._switch(new TypeRef.SwitchBlock(){

            @Override
            public void _case(TypeRef.ClassTypeRef typeRef) {
                PackageValidatorAdditionalCompilationVerificationVisitor.this.checkName(scope, typeRef.className);
                typeRef.typeArguments.ifPresent(value -> value.forEach(type -> PackageValidatorAdditionalCompilationVerificationVisitor.this.checkName(scope, type)));
            }

            @Override
            public void _case(TypeRef.ArrayTypeRef typeRef) {
                PackageValidatorAdditionalCompilationVerificationVisitor.this.checkName(scope, typeRef.heldType);
            }
        });
    }

    private void checkName(AdditionalPassScope scope, ReferenceExpression expression) {
        this.checkName(scope, expression.getJadtIdentifiers());
    }

    private void checkName(AdditionalPassScope scope, List<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (identifier.value.equalsIgnoreCase(this.namespaceNameLower)) {
                scope.getErrors().markInvalid(identifier.loc, I18nSupport.getLabel("explicit.unmanaged"));
            }
            this.checkName(scope, identifier);
        }
    }

    private void checkName(AdditionalPassScope scope, Identifier identifier) {
        String name = identifier.value.toLowerCase();
        if (name.startsWith(Namespaces.CUSTOM_METADATA.getGlobal().toLowerCase())) {
            name = name.substring(Namespaces.CUSTOM_METADATA.getGlobal().length());
        }
        if (name.startsWith(this.namespaceNameLower + "__")) {
            scope.getErrors().markInvalid(identifier.loc, I18nSupport.getLabel("explicit.unmanaged"));
        }
    }

    private void checkDescribeDataCategoryReferences(AdditionalPassScope scope, ReferenceExpression expression) {
        String fullName = PrinterUtil.get().getFactory().dottedIdentifier().print(expression.getJadtIdentifiers(), new PrintContext());
        if (fullName.equals("Schema.describeDataCategoryGroups") || fullName.equals("Schema.describeDataCategoryGroupStructures")) {
            scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("export.data.category"));
        }
    }
}

