/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;

public class IllegalInstanceReferenceVisitor
extends AstVisitor<ValidationScope> {
    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public boolean visit(MethodCallExpression node, ValidationScope scope) {
        boolean isImplicitThis;
        IdentifierContext context = this.getFirstContext(node.getReferenceExpression());
        boolean bl = isImplicitThis = context == IdentifierContext.NONE;
        if (node.getReferenceExpression().getVariables().isEmpty() && isImplicitThis && !node.getMethod().getModifiers().has(ModifierTypeInfos.STATIC)) {
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.method.reference.in.constructor", node.getMethod()));
            return false;
        }
        if (!node.getReferenceExpression().getVariables().isEmpty()) {
            this.visitVariable(node, node.getReferenceExpression().getVariables().get(0), context, scope);
        }
        return true;
    }

    @Override
    public boolean visit(VariableExpression node, ValidationScope scope) {
        return this.visitVariable(node, this.getFirstVariable(node), this.getFirstContext(node.getReferenceExpression()), scope);
    }

    @Override
    public boolean visit(SuperVariableExpression node, ValidationScope scope) {
        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "super"));
        return false;
    }

    @Override
    public boolean visit(ThisVariableExpression node, ValidationScope scope) {
        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "this"));
        return false;
    }

    private Variable getFirstVariable(VariableExpression expression) {
        return Iterables.getFirst(expression.getReferenceExpression().getVariables(), expression.getVariable());
    }

    private IdentifierContext getFirstContext(ReferenceExpression expression) {
        return expression.getContexts().stream().map(input -> input.previous).findFirst().orElse(expression.getContext());
    }

    private boolean visitVariable(AstNode node, Variable variable, IdentifierContext context, ValidationScope scope) {
        boolean isImplicitThis;
        boolean isLocal = variable.accept(new VariableVisitor.Default<Boolean>(){

            @Override
            public Boolean _default(Variable info, VariableVisitor.Context context) {
                return false;
            }

            @Override
            public Boolean visit(LocalInfo info, VariableVisitor.Context context) {
                return true;
            }
        }, VariableVisitor.Context.NONE);
        boolean bl = isImplicitThis = context == IdentifierContext.NONE;
        if (!isLocal && isImplicitThis && !variable.getModifiers().has(ModifierTypeInfos.STATIC)) {
            scope.getErrors().markInvalid(node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", variable.getName()));
            return false;
        }
        return true;
    }
}

