/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.services.Version;

public class ApiVersionVisitor
extends AstVisitor<ValueScope<Version>> {
    private static final ApiVersionVisitor INSTANCE = new ApiVersionVisitor();

    private ApiVersionVisitor() {
    }

    public static ApiVersionVisitor get() {
        return INSTANCE;
    }

    @Override
    public boolean visit(UserClass node, ValueScope<Version> scope) {
        return true;
    }

    @Override
    public void visitEnd(ModifierNode node, ValueScope<Version> scope) {
        node.resolve();
        scope.setValue(this.getVersionOverride(node.getModifiers()));
    }

    private Version getVersionOverride(ModifierGroup modifiers) {
        int annotationValue;
        ModifierOrAnnotation annotation = modifiers.get(AnnotationTypeInfos.API_VERSION);
        if (annotation == null) {
            return Version.CURRENT;
        }
        AnnotationParameter annotationParameter = annotation.getParameter("value");
        if (annotationParameter == null) {
            return Version.CURRENT;
        }
        try {
            annotationValue = annotationParameter.getIntegerValue();
        }
        catch (NumberFormatException e) {
            return Version.CURRENT;
        }
        try {
            return Version.fromInternal(annotationValue);
        }
        catch (IllegalArgumentException x) {
            return Version.CURRENT;
        }
    }
}

