/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import shaded.org.objectweb.asm.Label;

public class TryCatchFinallyBlockStatement
extends Statement {
    static final Emit UNCATCHABLE_EXCEPTION = emitter -> {
        emitter.emit(Loc._SyntheticLoc(), 89);
        emitter.emit(Loc._SyntheticLoc(), SystemMethods.isCatchableException());
        emitter.unbox(TypeInfos.BOOLEAN);
        Label exit = new Label();
        emitter.emitJump(Loc._SyntheticLoc(), 154, exit);
        emitter.emit(Loc._SyntheticLoc(), 191);
        emitter.emit(exit);
    };
    private final Loc loc;
    private final Statement tryBlock;
    private final List<CatchBlockStatement> catchBlocks;
    private final Statement finallyBlock;
    private final Emit finallyEmit;

    public TryCatchFinallyBlockStatement(AstNode definingNode, Stmnt.TryCatchFinallyBlock stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.tryBlock = AstNodeFactory.create((AstNode)this, stmnt.tryBlock);
        this.catchBlocks = MoreIterables.filterNullTransform(stmnt.catchBlocks, catchBlock -> new CatchBlockStatement(this, (CatchBlock)catchBlock));
        this.finallyBlock = stmnt.finallyBlock.map(value -> AstNodeFactory.create((AstNode)this, value.stmnt)).orElse(NOOP);
        this.finallyEmit = stmnt.finallyBlock.map(value -> this.finallyBlock::emit).orElse(Emit.NOOP);
        this.setReturnable(Iterables.concat(Collections.singletonList(this.tryBlock), this.catchBlocks));
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.tryBlock.traverse(visitor, scope);
            for (CatchBlockStatement catchBlock : this.catchBlocks) {
                catchBlock.traverse(visitor, scope);
            }
            this.finallyBlock.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        HashSet<TypeInfo> uniqueExceptions = Sets.newHashSet();
        this.tryBlock.validate(symbols, scope);
        for (CatchBlockStatement catchBlock : this.catchBlocks) {
            catchBlock.validate(symbols, scope);
            TypeInfo type = catchBlock.getVariable().getType();
            if (!type.isResolved()) continue;
            for (TypeInfo otherType : uniqueExceptions) {
                if (!Distance.get().canAssign(this.getDefiningType(), type, otherType)) continue;
                scope.getErrors().markInvalid((AstNode)catchBlock, I18nSupport.getLabel("invalid.catch.duplicate.exception", type));
            }
            uniqueExceptions.add(type);
        }
        this.finallyBlock.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.catchBlocks, this.tryBlock, this.finallyBlock)) {
            scope.getErrors().markInvalid(this);
        }
        if (this.catchBlocks.isEmpty() && this.finallyBlock == Statement.NOOP) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.try.needs.catch.or.finally"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        TryCatchFinallyStack.TryCatchFinallyContext context = emitter.getTryCatchFinallyStack().push(this.finallyEmit);
        emitter.getTryCatchFinallyStack().startTryBlock();
        emitter.emitStatementExecuted(this.loc, false, true);
        emitter.emit(context.tryStartForCatch);
        this.tryBlock.emit(emitter);
        emitter.getTryCatchFinallyStack().endBlock();
        if (!this.catchBlocks.isEmpty()) {
            emitter.emitJump(Loc._SyntheticLoc(), 167, context.exit);
        }
        for (CatchBlockStatement catchBlock : this.catchBlocks) {
            catchBlock.emit(emitter);
        }
        emitter.getTryCatchFinallyStack().pop(UNCATCHABLE_EXCEPTION);
        emitter.emit(context.exit);
        emitter.emit(Loc._SyntheticLoc(), 0);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

