/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class ThrowStatement
extends Statement {
    private final Loc loc;
    private final Expression expression;

    public ThrowStatement(AstNode definingNode, Stmnt.ThrowStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.expression = AstNodeFactory.create((AstNode)this, stmnt.expr);
        this.setReturnable(true);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!ExceptionTypeInfoUtil.isException(this.getDefiningType(), this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.throw.exception", this.expression.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.loc, true, false);
        this.expression.emit(emitter);
        emitter.emit(this.loc, 191);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }
}

