/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import java.util.List;

public class RunAsBlockStatement
extends Statement {
    private final List<Expression> parameters;
    private final Statement statement;
    private final Loc loc;
    private TypeInfo paramType;

    public RunAsBlockStatement(AstNode definingNode, Stmnt.RunAsBlock x) {
        super(definingNode);
        this.loc = x.loc;
        this.parameters = AstNodeFactory.createExpressions(this, x.inputParameters);
        this.statement = AstNodeFactory.create((AstNode)this, x.stmnt);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression parameter : this.parameters) {
                parameter.traverse(visitor, scope);
            }
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (Expression parameter : this.parameters) {
            parameter.validate(symbols, scope);
        }
        this.statement.validate(symbols, scope);
        if (this.parameters.size() != 1) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.runas"));
            return;
        }
        if (scope.getErrors().isInvalid(this.parameters, this.statement)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.paramType = this.parameters.get(0).getType();
        if (!(TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.SYSTEM_VERSION) || TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.PACKAGE_VERSION) || TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.SOBJECT_USER))) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.runas"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        Emit finallyEmit;
        MethodStack.MethodContext method = emitter.getMethodStack().peek();
        int index = method.getLocalVariables().add();
        for (Expression parameter : this.parameters) {
            parameter.emit(emitter);
        }
        if (TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.SOBJECT_USER)) {
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.runAsUserSetup());
            finallyEmit = this.getFinallyEmitter(index, SystemMethods.runAsUserCleanup());
        } else if (TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.SYSTEM_VERSION) || TypeInfoEquivalence.isEquivalent(this.paramType, InternalTypeInfos.PACKAGE_VERSION)) {
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.runAsVersionSetup());
            finallyEmit = this.getFinallyEmitter(index, SystemMethods.runAsVersionCleanup());
        } else {
            throw new UnexpectedCodePathException();
        }
        emitter.emitVar(Loc._SyntheticLoc(), 58, index);
        emitter.getTryCatchFinallyStack().push(finallyEmit);
        emitter.getTryCatchFinallyStack().startTryBlock();
        this.statement.emit(emitter);
        emitter.getTryCatchFinallyStack().endBlock();
        emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    private Emit getFinallyEmitter(int index, AsmMethod cleanup) {
        return emitter -> {
            emitter.emitVar(Loc._SyntheticLoc(), 25, index);
            emitter.emit(Loc._SyntheticLoc(), cleanup);
        };
    }
}

