/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;

public class ReturnStatement
extends Statement {
    private final Expression expression;
    private final Loc loc;

    public ReturnStatement(AstNode definingNode, Stmnt.ReturnStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.expression = stmnt.expr.map(value -> AstNodeFactory.create((AstNode)this, value)).orElse(Expression.NOOP);
        this.setReturnable(true);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid((AstNode)this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (scope.isOutsideMethod()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.return.from.non.method"));
        } else if (this.isTriggerInvoke(scope.getMethod()) && this.expression != Expression.NOOP) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.trigger.return"));
        } else if (scope.getMethod().isConstructor() && this.expression != Expression.NOOP) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.constructor.return"));
        } else if (this.expression != Expression.NOOP && !scope.getMethod().hasReturnValue()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.return.void"));
        } else if (this.expression == Expression.NOOP && scope.getMethod().hasReturnValue()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.return.non.void", scope.getMethod().getReturnType()));
        } else if (this.expression != Expression.NOOP && !Distance.get().canAssign(this.getDefiningType(), this.expression.getType(), scope.getMethod().getReturnType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("illegal.conversion", this.expression.getType(), scope.getMethod().getReturnType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        MethodStack.MethodContext method = emitter.getMethodStack().peek();
        emitter.emitStatementExecuted(this.loc, true, false);
        if (this.expression != Expression.NOOP) {
            this.expression.emit(emitter);
            TypeConversion.emit(this.loc, emitter, this.expression.getType(), method.getMethodInfo().getReturnType());
        }
        if (method.getMethodInfo().hasReturnValue() && emitter.getTryCatchFinallyStack().hasFinally()) {
            int position = method.getLocalVariables().get();
            emitter.emitVar(Loc._SyntheticLoc(), 58, position);
            emitter.getTryCatchFinallyStack().emitFinallyJumps();
            emitter.emitVar(Loc._SyntheticLoc(), 25, position);
            method.getLocalVariables().clear(position);
        } else {
            emitter.getTryCatchFinallyStack().emitFinallyJumps();
        }
        emitter.emit(this.loc, this.expression == Expression.NOOP ? 177 : 176);
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    private boolean isTriggerInvoke(MethodInfo method) {
        return method.getDefiningType().getUnitType() == UnitType.TRIGGER && method.getName().equals("invoke");
    }
}

