/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodeFactory;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.statement.ForEachInitFactory;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.DatabaseMethods;
import apex.jorje.semantic.bcl.IteratorMethods;
import apex.jorje.semantic.bcl.ListMethods;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.bcl.SystemMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import shaded.org.objectweb.asm.Label;

public class ForEachStatement
extends Statement {
    private final Expression list;
    private final ForEachInitFactory.ForEachVariable variable;
    private final Loc loc;
    private final Statement bodyStatement;
    private final LocalVariableScope locals;
    private final boolean hasBlock;
    private GenericTypeInfo listType;
    private TypeInfo elementType;
    private ListCreator listCreator;
    private TypeInfo listElementType;

    public ForEachStatement(AstNode definingNode, Stmnt.ForLoop stmnt, ForControl.EnhancedForControl forControl) {
        super(definingNode);
        this.variable = ForEachInitFactory.create(this, forControl);
        this.list = AstNodeFactory.create((AstNode)this, forControl.init.expr);
        this.loc = stmnt.loc;
        this.bodyStatement = AstNodeFactory.createLoopStatement(this, stmnt.stmnt);
        this.locals = new LocalVariableScope();
        this.hasBlock = stmnt.stmnt.isPresent();
        this.list.getOptions().isListForEachStatement = true;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        if (visitor.visit(this, scope)) {
            this.variable.declaration.traverse(visitor, scope);
            this.variable.expression.traverse(visitor, scope);
            this.list.traverse(visitor, scope);
            this.bodyStatement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
        scope.pop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            this.list.validate(symbols, scope);
            this.variable.declaration.validate(symbols, scope);
            if (!scope.getErrors().isInvalid((AstNode)this.variable.declaration)) {
                this.variable.expression.validate(symbols, scope);
            }
            this.bodyStatement.validate(symbols, scope);
            if (scope.getErrors().isInvalid(this.variable.declaration, this.variable.expression, this.list, this.bodyStatement)) {
                scope.getErrors().markInvalid(this);
                return;
            }
            if (!CollectionTypeInfoUtil.isCollection(this.list.getType())) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.must.iterate.over.collection", this.list.getType()));
                return;
            }
            this.listCreator = ListCreator.get(this.list);
            this.listType = (GenericTypeInfo)this.list.getType();
            this.elementType = this.variable.expression.getType();
            this.listElementType = CollectionTypeInfoUtil.getElementType(this.listType);
            if (this.listCreator.isQueryBased()) {
                if (!this.hasBlock) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.with.query.requires.statement"));
                }
                if (SObjectTypeInfoUtil.isConcreteSObjectList(this.listType)) {
                    TypeInfo innerElementType;
                    TypeInfo typeInfo = innerElementType = CollectionTypeInfoUtil.isList(this.elementType) ? CollectionTypeInfoUtil.getElementType(this.elementType) : this.elementType;
                    if (!(TypeInfoEquivalence.isEquivalent(innerElementType, TypeInfos.SOBJECT) || SObjectTypeInfoUtil.isGenericSObjectList(this.elementType) || TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(this.listType), innerElementType))) {
                        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.variable.mismatch.concrete.sobject.type", CollectionTypeInfoUtil.getElementType(this.listType)));
                    }
                } else if (this.elementType.getBasicType() != BasicType.SOBJECT && !SObjectTypeInfoUtil.isSObjectList(this.elementType)) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.variable.mismatch.sobject.type"));
                }
            } else if (!Distance.get().canAssign(this.getDefiningType(), this.listElementType, this.elementType)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.loop.type", this.listElementType, this.elementType));
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        IteratorInfo iterator;
        boolean isChunkIterator = this.isChunkIterator(emitter.getVersion());
        LoopStack loopStack = emitter.getLoopStack();
        LoopStack.LoopContext loop = new LoopStack.LoopContext(emitter, this.bodyStatement.getLoc(), this.getLoc());
        loop.emitIterationCounter();
        boolean isAggregateQuery = false;
        switch (this.listCreator) {
            case SET: {
                iterator = IteratorInfo.builder().setIsQueryResult(false).setIsChunkIterator(isChunkIterator).setListType(this.listType).build();
                emitter.emitType(this.getLoc(), 187, iterator.iteratorDefiningType);
                emitter.emit(this.getLoc(), 89);
                emitter.emit(this.getLoc(), ObjectMethods.constructor(iterator.iteratorDefiningType, new TypeInfo[0]));
                emitter.emit(this.getLoc(), 89);
                this.list.emit(emitter);
                emitter.emit(this.getLoc(), ListMethods.addAll(TypeInfos.LIST));
                break;
            }
            case SOQL_EXPRESSION: {
                SoqlExpression soql = ExpressionUtil.getSoqlExpression(this.list);
                isAggregateQuery = soql.isAggregateQuery();
                soql.getBindExpression().emit(emitter);
                emitter.push(Loc._SyntheticLoc(), true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.push(Loc._SyntheticLoc(), isChunkIterator);
                emitter.box(TypeInfos.BOOLEAN);
                ProfilingType.SOQL.emit(emitter, this.getLoc(), soql.getQuery());
                emitter.emit(Loc._SyntheticLoc(), DatabaseMethods.getQueryLocator());
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case SOQL_DOTTED_EXPRESSION: 
            case AGGREGATE_FIELD: {
                this.list.emit(emitter);
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsDottedQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case DATABASE_QUERY: {
                MethodCallExpression queryCall = ExpressionUtil.getMethodCallExpression(this.list);
                queryCall.getInputParameters().get(0).emit(emitter);
                emitter.emit(Loc._SyntheticLoc(), 1);
                emitter.push(Loc._SyntheticLoc(), true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.push(Loc._SyntheticLoc(), isChunkIterator);
                emitter.box(TypeInfos.BOOLEAN);
                ProfilingType.METHOD.emit(emitter, queryCall);
                emitter.emit(Loc._SyntheticLoc(), DatabaseMethods.getQueryLocator());
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case GET_SOBJECTS: {
                MethodCallExpression getSObjectsCall = ExpressionUtil.getMethodCallExpression(this.list);
                MethodInfo method = getSObjectsCall.getMethod();
                assert (method.getParameters().size() == 1);
                assert (method.getParameters().get(0).getType().equals(TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, method.getParameters().get(0).getType()));
                getSObjectsCall.getReferenceExpression().getOptions().isListForEachStatement = true;
                getSObjectsCall.emitReferenceExpression(emitter);
                getSObjectsCall.getInputParameters().get(0).emit(emitter);
                if (method.getParameters().get(0).getType().equals(TypeInfos.STRING)) {
                    emitter.emit(this.getLoc(), SObjectMethods.getSObjectsSelectLoop(TypeInfos.STRING));
                } else if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, method.getParameters().get(0).getType())) {
                    emitter.emit(this.getLoc(), SObjectMethods.getSObjectsSelectLoop(TypeInfos.OBJECT));
                } else {
                    throw new UnexpectedCodePathException();
                }
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case LIST: {
                this.list.emit(emitter);
                iterator = IteratorInfo.builder().setIsQueryResult(false).setIsChunkIterator(isChunkIterator).setListType(this.listType).build();
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
        if (iterator.requiresSystemMode()) {
            int index = emitter.getMethodStack().peek().getLocalVariables().add();
            emitter.emit(Loc._SyntheticLoc(), 89);
            emitter.emitVar(this.getLoc(), 58, index);
            emitter.getTryCatchFinallyStack().push(this.getFinallyEmitter(index));
            emitter.getTryCatchFinallyStack().startTryBlock();
        }
        if (isChunkIterator) {
            emitter.push(this.getLoc(), isAggregateQuery);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(this.list.getLoc(), ListMethods.chunkIterator(iterator.iteratorDefiningType, iterator.iteratorReturnType));
        } else {
            emitter.emit(this.list.getLoc(), ListMethods.iterator(iterator.iteratorDefiningType, iterator.iteratorReturnType));
        }
        int iteratorVariable = emitter.getMethodStack().peek().getLocalVariables().add();
        emitter.emitVar(this.list.getLoc(), 58, iteratorVariable);
        loop.setTryStackSize();
        loopStack.push(loop);
        Label start = new Label();
        emitter.emit(start);
        loop.emitContinueLabel();
        emitter.emitVar(this.list.getLoc(), 25, iteratorVariable);
        emitter.emit(Loc._SyntheticLoc(), IteratorMethods.hasNext(iterator.iteratorReturnType));
        emitter.unbox(TypeInfos.BOOLEAN);
        Label exit = new Label();
        emitter.emitJump(Loc._SyntheticLoc(), 153, exit);
        emitter.emitVar(this.list.getLoc(), 25, iteratorVariable);
        emitter.emit(Loc._SyntheticLoc(), IteratorMethods.next(iterator.iteratorReturnType, iterator.elementType));
        if (!TypeInfoEquivalence.isEquivalent(this.elementType, TypeInfos.OBJECT)) {
            emitter.emit(Loc._SyntheticLoc(), 89);
            emitter.push(Loc._SyntheticLoc(), this.elementType.getBytecodeName());
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.validateVariableTypeForSelectLoop());
            emitter.push(Loc._SyntheticLoc(), this.elementType.getBytecodeName());
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.convert());
        }
        this.variable.expression.emit(emitter);
        loop.emitIterationCounterIncrement();
        this.bodyStatement.emit(emitter);
        emitter.emitJump(this.bodyStatement.getLoc(), 167, start);
        emitter.emit(exit);
        LoopStack.LoopContext sanity = loopStack.pop();
        assert (loop == sanity);
        emitter.emit(this.list.getLoc(), 1);
        emitter.emitVar(this.list.getLoc(), 58, iteratorVariable);
        emitter.emit(this.list.getLoc(), 1);
        this.variable.expression.emit(emitter);
        loop.emitZeroIterationCounter();
        if (iterator.requiresSystemMode()) {
            emitter.getTryCatchFinallyStack().endBlock();
            emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
        }
    }

    @Override
    public Loc getLoc() {
        return this.loc;
    }

    private Emit getFinallyEmitter(int index) {
        return emitter -> {
            emitter.emitVar(this.getLoc(), 25, index);
            emitter.emit(Loc._SyntheticLoc(), SystemMethods.removeKeepAliveCursor());
            emitter.emit(this.getLoc(), 1);
            emitter.emitVar(this.getLoc(), 58, index);
        };
    }

    private boolean isChunkIterator(Version applicableVersion) {
        if (CollectionTypeInfoUtil.isList(this.listType) && (CollectionTypeInfoUtil.isSet(this.elementType) || CollectionTypeInfoUtil.isList(this.elementType))) {
            TypeInfo elementElementType = CollectionTypeInfoUtil.getElementType(this.elementType);
            return Distance.get().canAssign(applicableVersion, elementElementType, this.listElementType) || this.elementType.getBasicType() == BasicType.SOBJECT && SObjectTypeInfoUtil.isGenericSObjectList(this.listType);
        }
        return false;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    private static class IteratorInfo {
        private final boolean isQueryResult;
        private final TypeInfo iteratorReturnType;
        private final TypeInfo elementType;
        private final TypeInfo iteratorDefiningType;
        private final boolean isDottedQueryResult;

        public IteratorInfo(Builder builder) {
            this.isQueryResult = builder.isQueryResult;
            this.iteratorReturnType = builder.iteratorReturnType;
            this.elementType = builder.elementType;
            this.iteratorDefiningType = builder.iteratorDefiningType;
            this.isDottedQueryResult = builder.isDottedQueryResult;
        }

        private static Builder builder() {
            return new Builder();
        }

        public boolean requiresSystemMode() {
            return this.isQueryResult && !this.isDottedQueryResult;
        }

        private static class Builder {
            private boolean isQueryResult;
            private boolean isChunkIterator;
            private TypeInfo iteratorDefiningType;
            private TypeInfo elementType;
            private InternalTypeInfo iteratorReturnType;
            private GenericTypeInfo oldListType;
            private boolean isDottedQueryResult;

            private Builder() {
            }

            public IteratorInfo build() {
                if (this.isQueryResult) {
                    if (this.isChunkIterator) {
                        this.iteratorReturnType = InternalTypeInfos.DATABASE_QUERY_LOCATOR_CHUNK_ITERATOR;
                        this.elementType = TypeInfos.OBJECT;
                    } else {
                        this.iteratorReturnType = InternalTypeInfos.DATABASE_QUERY_LOCATOR_ITERATOR;
                        this.elementType = TypeInfos.SOBJECT;
                    }
                } else {
                    this.iteratorReturnType = InternalTypeInfos.SYSTEM_ITERATOR;
                    this.elementType = TypeInfos.OBJECT;
                }
                this.iteratorDefiningType = this.isQueryResult ? InternalTypeInfos.DATABASE_QUERY_LOCATOR : (CollectionTypeInfoUtil.isSet(this.oldListType) ? GenericTypeInfoFactory.createList(CollectionTypeInfoUtil.getElementType(this.oldListType)) : this.oldListType);
                return new IteratorInfo(this);
            }

            public Builder setIsQueryResult(boolean isQueryResult) {
                this.isQueryResult = isQueryResult;
                return this;
            }

            public Builder setIsChunkIterator(boolean isChunkIterator) {
                this.isChunkIterator = isChunkIterator;
                return this;
            }

            public Builder setListType(GenericTypeInfo listType) {
                this.oldListType = listType;
                return this;
            }

            public Builder setIsDottedQueryResult(boolean isDottedQueryResult) {
                this.isDottedQueryResult = isDottedQueryResult;
                return this;
            }
        }
    }

    private static enum ListCreator {
        SET(false),
        SOQL_EXPRESSION(true),
        SOQL_DOTTED_EXPRESSION(true),
        DATABASE_QUERY(true),
        GET_SOBJECTS(true),
        AGGREGATE_FIELD(true),
        LIST(false);

        private final boolean isQueryBased;

        private ListCreator(boolean isQueryBased) {
            this.isQueryBased = isQueryBased;
        }

        private static boolean isGetSObjects(Expression expression) {
            return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

                @Override
                public void visitEnd(MethodCallExpression node, ValueScope<Boolean> scope) {
                    MethodInfo method = node.getMethod();
                    scope.setValue(method.getDefiningType().getBasicType() == BasicType.SOBJECT && method.getName().equalsIgnoreCase("getSObjects"));
                }
            }, false);
        }

        private static boolean isDatabaseQuery(Expression expression) {
            return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

                @Override
                public void visitEnd(MethodCallExpression node, ValueScope<Boolean> scope) {
                    MethodInfo method = node.getMethod();
                    scope.setValue(TypeInfoEquivalence.isEquivalent(InternalTypeInfos.DATABASE, method.getDefiningType()) && method.getName().equalsIgnoreCase("query"));
                }
            }, false);
        }

        private static boolean isAggregateField(Expression expression) {
            return ValueScope.evaluate(expression, new AstVisitor<ValueScope<Boolean>>(){

                @Override
                public void visitEnd(VariableExpression node, ValueScope<Boolean> scope) {
                    if (node.getReferenceType() == ReferenceType.LOAD) {
                        scope.setValue(node.getVariable().accept(new VariableVisitor.Default<Boolean>(){

                            @Override
                            public Boolean _default(Variable info, VariableVisitor.Context context) {
                                return false;
                            }

                            @Override
                            public Boolean visit(SObjectFieldInfo info, VariableVisitor.Context context) {
                                return info.getCategory() == SObjectFieldInfo.Category.AGGREGATE;
                            }
                        }, null));
                    }
                }
            }, false);
        }

        private static ListCreator get(Expression expression) {
            if (CollectionTypeInfoUtil.isSet(expression.getType())) {
                return SET;
            }
            if (ExpressionUtil.isSoqlExpression(expression)) {
                return SOQL_EXPRESSION;
            }
            if (ExpressionUtil.isSoqlDottedExpression(expression)) {
                return SOQL_DOTTED_EXPRESSION;
            }
            if (ListCreator.isDatabaseQuery(expression)) {
                return DATABASE_QUERY;
            }
            if (ListCreator.isGetSObjects(expression)) {
                return GET_SOBJECTS;
            }
            if (ListCreator.isAggregateField(expression)) {
                return AGGREGATE_FIELD;
            }
            return LIST;
        }

        public boolean isQueryBased() {
            return this.isQueryBased;
        }
    }
}

